/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.application.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ServiceLoader;
import org.operaton.bpm.application.AbstractProcessApplication;
import org.operaton.bpm.application.ProcessApplicationElResolver;
import org.operaton.bpm.application.impl.ProcessApplicationLogger;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.impl.juel.jakarta.el.CompositeELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.ELResolver;

public class DefaultElResolverLookup {
    private static final ProcessApplicationLogger LOG = ProcessEngineLogger.PROCESS_APPLICATION_LOGGER;

    public static final ELResolver lookupResolver(AbstractProcessApplication processApplication) {
        ServiceLoader<ProcessApplicationElResolver> providers = ServiceLoader.load(ProcessApplicationElResolver.class);
        ArrayList<ProcessApplicationElResolver> sortedProviders = new ArrayList<ProcessApplicationElResolver>();
        for (ProcessApplicationElResolver provider : providers) {
            sortedProviders.add(provider);
        }
        if (sortedProviders.isEmpty()) {
            return null;
        }
        Collections.sort(sortedProviders, new ProcessApplicationElResolver.ProcessApplicationElResolverSorter());
        CompositeELResolver compositeResolver = new CompositeELResolver();
        StringBuilder summary = new StringBuilder();
        summary.append(String.format("ElResolvers found for Process Application %s", processApplication.getName()));
        for (ProcessApplicationElResolver processApplicationElResolver : sortedProviders) {
            ELResolver elResolver = processApplicationElResolver.getElResolver(processApplication);
            if (elResolver != null) {
                compositeResolver.add(elResolver);
                summary.append(String.format("Class %s", processApplicationElResolver.getClass().getName()));
                continue;
            }
            LOG.noElResolverProvided(processApplication.getName(), processApplicationElResolver.getClass().getName());
        }
        LOG.paElResolversDiscovered(summary.toString());
        return compositeResolver;
    }
}

