/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.container.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.ProcessApplicationService;
import org.operaton.bpm.ProcessEngineService;
import org.operaton.bpm.application.AbstractProcessApplication;
import org.operaton.bpm.application.ProcessApplicationInfo;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.container.ExecutorService;
import org.operaton.bpm.container.RuntimeContainerDelegate;
import org.operaton.bpm.container.impl.ContainerIntegrationLogger;
import org.operaton.bpm.container.impl.deployment.DeployProcessArchivesStep;
import org.operaton.bpm.container.impl.deployment.NotifyPostProcessApplicationUndeployedStep;
import org.operaton.bpm.container.impl.deployment.ParseProcessesXmlStep;
import org.operaton.bpm.container.impl.deployment.PostDeployInvocationStep;
import org.operaton.bpm.container.impl.deployment.PreUndeployInvocationStep;
import org.operaton.bpm.container.impl.deployment.ProcessesXmlStartProcessEnginesStep;
import org.operaton.bpm.container.impl.deployment.ProcessesXmlStopProcessEnginesStep;
import org.operaton.bpm.container.impl.deployment.StartProcessApplicationServiceStep;
import org.operaton.bpm.container.impl.deployment.StopProcessApplicationServiceStep;
import org.operaton.bpm.container.impl.deployment.UndeployProcessArchivesStep;
import org.operaton.bpm.container.impl.jmx.MBeanServiceContainer;
import org.operaton.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.operaton.bpm.container.impl.jmx.services.JmxManagedProcessEngine;
import org.operaton.bpm.container.impl.spi.DeploymentOperationStep;
import org.operaton.bpm.container.impl.spi.PlatformServiceContainer;
import org.operaton.bpm.container.impl.spi.ServiceTypes;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class RuntimeContainerDelegateImpl
implements RuntimeContainerDelegate,
ProcessEngineService,
ProcessApplicationService {
    protected static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;
    protected MBeanServiceContainer serviceContainer = new MBeanServiceContainer();
    public static final String SERVICE_NAME_EXECUTOR = "executor-service";
    public static final String SERVICE_NAME_PLATFORM_PLUGINS = "bpm-platform-plugins";

    @Override
    public void registerProcessEngine(ProcessEngine processEngine) {
        EnsureUtil.ensureNotNull("Cannot register process engine in Jmx Runtime Container", "process engine", (Object)processEngine);
        String processEngineName = processEngine.getName();
        JmxManagedProcessEngine managedProcessEngine = new JmxManagedProcessEngine(processEngine);
        this.serviceContainer.startService(ServiceTypes.PROCESS_ENGINE, processEngineName, managedProcessEngine);
    }

    @Override
    public void unregisterProcessEngine(ProcessEngine processEngine) {
        EnsureUtil.ensureNotNull("Cannot unregister process engine in Jmx Runtime Container", "process engine", (Object)processEngine);
        this.serviceContainer.stopService(ServiceTypes.PROCESS_ENGINE, processEngine.getName());
    }

    @Override
    public void deployProcessApplication(AbstractProcessApplication processApplication) {
        EnsureUtil.ensureNotNull("Process application", (Object)processApplication);
        String operationName = "Deployment of Process Application " + processApplication.getName();
        this.serviceContainer.createDeploymentOperation(operationName).addAttachment("processApplication", processApplication).addSteps(this.getDeploymentSteps()).execute();
        LOG.paDeployed(processApplication.getName());
    }

    @Override
    public void undeployProcessApplication(AbstractProcessApplication processApplication) {
        EnsureUtil.ensureNotNull("Process application", (Object)processApplication);
        String processAppName = processApplication.getName();
        if (this.serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processAppName) == null) {
            return;
        }
        String operationName = "Undeployment of Process Application " + processAppName;
        this.serviceContainer.createUndeploymentOperation(operationName).addAttachment("processApplication", processApplication).addSteps(this.getUndeploymentSteps()).execute();
        LOG.paUndeployed(processApplication.getName());
    }

    protected List<DeploymentOperationStep> getDeploymentSteps() {
        return Arrays.asList(new ParseProcessesXmlStep(), new ProcessesXmlStartProcessEnginesStep(), new DeployProcessArchivesStep(), new StartProcessApplicationServiceStep(), new PostDeployInvocationStep());
    }

    protected List<DeploymentOperationStep> getUndeploymentSteps() {
        return Arrays.asList(new PreUndeployInvocationStep(), new UndeployProcessArchivesStep(), new ProcessesXmlStopProcessEnginesStep(), new StopProcessApplicationServiceStep(), new NotifyPostProcessApplicationUndeployedStep());
    }

    @Override
    public ProcessEngineService getProcessEngineService() {
        return this;
    }

    @Override
    public ProcessApplicationService getProcessApplicationService() {
        return this;
    }

    @Override
    public ExecutorService getExecutorService() {
        return (ExecutorService)this.serviceContainer.getServiceValue(ServiceTypes.BPM_PLATFORM, SERVICE_NAME_EXECUTOR);
    }

    @Override
    public ProcessEngine getDefaultProcessEngine() {
        return (ProcessEngine)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, "default");
    }

    @Override
    public ProcessEngine getProcessEngine(String name) {
        return (ProcessEngine)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_ENGINE, name);
    }

    @Override
    public List<ProcessEngine> getProcessEngines() {
        return this.serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_ENGINE);
    }

    @Override
    public Set<String> getProcessEngineNames() {
        HashSet<String> processEngineNames = new HashSet<String>();
        List<ProcessEngine> processEngines = this.getProcessEngines();
        for (ProcessEngine processEngine : processEngines) {
            processEngineNames.add(processEngine.getName());
        }
        return processEngineNames;
    }

    @Override
    public Set<String> getProcessApplicationNames() {
        List processApplications = this.serviceContainer.getServiceValuesByType(ServiceTypes.PROCESS_APPLICATION);
        HashSet<String> processApplicationNames = new HashSet<String>();
        for (JmxManagedProcessApplication jmxManagedProcessApplication : processApplications) {
            processApplicationNames.add(jmxManagedProcessApplication.getProcessApplicationName());
        }
        return processApplicationNames;
    }

    @Override
    public ProcessApplicationInfo getProcessApplicationInfo(String processApplicationName) {
        JmxManagedProcessApplication processApplicationService = (JmxManagedProcessApplication)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplicationName);
        if (processApplicationService == null) {
            return null;
        }
        return processApplicationService.getProcessApplicationInfo();
    }

    @Override
    public ProcessApplicationReference getDeployedProcessApplication(String processApplicationName) {
        JmxManagedProcessApplication processApplicationService = (JmxManagedProcessApplication)this.serviceContainer.getServiceValue(ServiceTypes.PROCESS_APPLICATION, processApplicationName);
        if (processApplicationService == null) {
            return null;
        }
        return processApplicationService.getProcessApplicationReference();
    }

    public PlatformServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }
}

