/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.history.CleanableHistoricBatchReport;
import org.operaton.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.CleanableHistoricInstanceReportProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.batch.BatchJobHandler;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;

public class CleanableHistoricBatchReportImpl
extends AbstractQuery<CleanableHistoricBatchReport, CleanableHistoricBatchReportResult>
implements CleanableHistoricBatchReport {
    private static final long serialVersionUID = 1L;
    protected Date currentTimestamp;
    protected boolean isHistoryCleanupStrategyRemovalTimeBased;

    public CleanableHistoricBatchReportImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CleanableHistoricBatchReport orderByFinishedBatchOperation() {
        this.orderBy(CleanableHistoricInstanceReportProperty.FINISHED_AMOUNT);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        this.checkPermissions(commandContext);
        Map<String, Integer> batchOperationsForHistoryCleanup = commandContext.getProcessEngineConfiguration().getParsedBatchOperationsForHistoryCleanup();
        if (this.isHistoryCleanupStrategyRemovalTimeBased()) {
            this.addBatchOperationsWithoutTTL(batchOperationsForHistoryCleanup);
        }
        return commandContext.getHistoricBatchManager().findCleanableHistoricBatchesReportCountByCriteria(this, batchOperationsForHistoryCleanup);
    }

    @Override
    public List<CleanableHistoricBatchReportResult> executeList(CommandContext commandContext, Page page) {
        this.provideHistoryCleanupStrategy(commandContext);
        this.checkQueryOk();
        this.checkPermissions(commandContext);
        Map<String, Integer> batchOperationsForHistoryCleanup = commandContext.getProcessEngineConfiguration().getParsedBatchOperationsForHistoryCleanup();
        if (this.isHistoryCleanupStrategyRemovalTimeBased()) {
            this.addBatchOperationsWithoutTTL(batchOperationsForHistoryCleanup);
        }
        return commandContext.getHistoricBatchManager().findCleanableHistoricBatchesReportByCriteria(this, page, batchOperationsForHistoryCleanup);
    }

    protected void addBatchOperationsWithoutTTL(Map<String, Integer> batchOperations) {
        Map<String, BatchJobHandler<?>> batchJobHandlers = Context.getProcessEngineConfiguration().getBatchHandlers();
        Set<String> batchOperationKeys = null;
        if (batchJobHandlers != null) {
            batchOperationKeys = batchJobHandlers.keySet();
        }
        if (batchOperationKeys != null) {
            for (String batchOperation : batchOperationKeys) {
                Integer ttl = batchOperations.get(batchOperation);
                batchOperations.put(batchOperation, ttl);
            }
        }
    }

    public Date getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    public void setCurrentTimestamp(Date currentTimestamp) {
        this.currentTimestamp = currentTimestamp;
    }

    private void checkPermissions(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadHistoricBatch();
        }
    }

    protected void provideHistoryCleanupStrategy(CommandContext commandContext) {
        String historyCleanupStrategy = commandContext.getProcessEngineConfiguration().getHistoryCleanupStrategy();
        this.isHistoryCleanupStrategyRemovalTimeBased = "removalTimeBased".equals(historyCleanupStrategy);
    }

    public boolean isHistoryCleanupStrategyRemovalTimeBased() {
        return this.isHistoryCleanupStrategyRemovalTimeBased;
    }
}

