/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.db.PermissionCheck;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.management.DeploymentStatistics;
import org.operaton.bpm.engine.management.DeploymentStatisticsQuery;

public class DeploymentStatisticsQueryImpl
extends AbstractQuery<DeploymentStatisticsQuery, DeploymentStatistics>
implements DeploymentStatisticsQuery {
    protected static final long serialVersionUID = 1L;
    protected boolean includeFailedJobs = false;
    protected boolean includeIncidents = false;
    protected String includeIncidentsForType;
    protected List<PermissionCheck> processInstancePermissionChecks = new ArrayList<PermissionCheck>();
    protected List<PermissionCheck> jobPermissionChecks = new ArrayList<PermissionCheck>();
    protected List<PermissionCheck> incidentPermissionChecks = new ArrayList<PermissionCheck>();

    public DeploymentStatisticsQueryImpl(CommandExecutor executor) {
        super(executor);
    }

    @Override
    public DeploymentStatisticsQuery includeFailedJobs() {
        this.includeFailedJobs = true;
        return this;
    }

    @Override
    public DeploymentStatisticsQuery includeIncidents() {
        this.includeIncidents = true;
        return this;
    }

    @Override
    public DeploymentStatisticsQuery includeIncidentsForType(String incidentType) {
        this.includeIncidentsForType = incidentType;
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsCountGroupedByDeployment(this);
    }

    @Override
    public List<DeploymentStatistics> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getStatisticsManager().getStatisticsGroupedByDeployment(this, page);
    }

    public boolean isFailedJobsToInclude() {
        return this.includeFailedJobs;
    }

    public boolean isIncidentsToInclude() {
        return this.includeIncidents || this.includeIncidentsForType != null;
    }

    @Override
    protected void checkQueryOk() {
        super.checkQueryOk();
        if (this.includeIncidents && this.includeIncidentsForType != null) {
            throw new ProcessEngineException("Invalid query: It is not possible to use includeIncident() and includeIncidentForType() to execute one query.");
        }
    }

    public List<PermissionCheck> getProcessInstancePermissionChecks() {
        return this.processInstancePermissionChecks;
    }

    public void setProcessInstancePermissionChecks(List<PermissionCheck> processInstancePermissionChecks) {
        this.processInstancePermissionChecks = processInstancePermissionChecks;
    }

    public void addProcessInstancePermissionCheck(List<PermissionCheck> permissionChecks) {
        this.processInstancePermissionChecks.addAll(permissionChecks);
    }

    public List<PermissionCheck> getJobPermissionChecks() {
        return this.jobPermissionChecks;
    }

    public void setJobPermissionChecks(List<PermissionCheck> jobPermissionChecks) {
        this.jobPermissionChecks = jobPermissionChecks;
    }

    public void addJobPermissionCheck(List<PermissionCheck> permissionChecks) {
        this.jobPermissionChecks.addAll(permissionChecks);
    }

    public List<PermissionCheck> getIncidentPermissionChecks() {
        return this.incidentPermissionChecks;
    }

    public void setIncidentPermissionChecks(List<PermissionCheck> incidentPermissionChecks) {
        this.incidentPermissionChecks = incidentPermissionChecks;
    }

    public void addIncidentPermissionCheck(List<PermissionCheck> permissionChecks) {
        this.incidentPermissionChecks.addAll(permissionChecks);
    }
}

