/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.ant;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.ProcessEngineInfo;
import org.operaton.bpm.engine.ProcessEngines;
import org.operaton.bpm.engine.RepositoryService;
import org.operaton.bpm.engine.impl.util.IoUtil;
import org.operaton.bpm.engine.impl.util.LogUtil;

public class DeployBarTask
extends Task {
    String processEngineName = "default";
    File file;
    List<FileSet> fileSets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        ArrayList<File> files = new ArrayList<File>();
        if (this.file != null) {
            files.add(this.file);
        }
        if (this.fileSets != null) {
            for (FileSet fileSet : this.fileSets) {
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                File baseDir = directoryScanner.getBasedir();
                String[] includedFiles = directoryScanner.getIncludedFiles();
                String[] excludedFiles = directoryScanner.getExcludedFiles();
                List<String> excludedFilesList = Arrays.asList(excludedFiles);
                for (String includedFile : includedFiles) {
                    if (excludedFilesList.contains(includedFile)) continue;
                    files.add(new File(baseDir, includedFile));
                }
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(DeployBarTask.class.getClassLoader());
        LogUtil.readJavaUtilLoggingConfigFromClasspath();
        try {
            this.log("Initializing process engine " + this.processEngineName);
            ProcessEngines.init();
            ProcessEngine processEngine = ProcessEngines.getProcessEngine(this.processEngineName);
            if (processEngine == null) {
                List<ProcessEngineInfo> processEngineInfos = ProcessEngines.getProcessEngineInfos();
                if (processEngineInfos == null || processEngineInfos.size() <= 0) throw new ProcessEngineException("Could not find a process engine with name '" + this.processEngineName + "', no engines found. Make sure an engine configuration is present on the classpath");
                String message = this.getErrorMessage(processEngineInfos, this.processEngineName);
                throw new ProcessEngineException(message);
            }
            RepositoryService repositoryService = processEngine.getRepositoryService();
            this.log("Starting to deploy " + files.size() + " files");
            for (File file : files) {
                String path = file.getAbsolutePath();
                this.log("Handling file " + path);
                try {
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        this.log("deploying bar " + path);
                        repositoryService.createDeployment().name(file.getName()).addZipInputStream(new ZipInputStream(inputStream)).deploy();
                    }
                    finally {
                        IoUtil.closeSilently(inputStream);
                    }
                }
                catch (Exception e) {
                    throw new BuildException("couldn't deploy bar " + path + ": " + e.getMessage(), (Throwable)e);
                    return;
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    private String getErrorMessage(List<ProcessEngineInfo> processEngineInfos, String name) {
        StringBuilder builder = new StringBuilder("Could not find a process engine with name ");
        builder.append(name).append(", engines loaded:\n");
        for (ProcessEngineInfo engineInfo : processEngineInfos) {
            String engineName = engineInfo.getName() != null ? engineInfo.getName() : "unknown";
            builder.append("Process engine name: ").append(engineName);
            builder.append(" - resource: ").append(engineInfo.getResourceUrl());
            builder.append(" - status: ");
            if (engineInfo.getException() != null) {
                builder.append("Error while initializing engine. ");
                if (engineInfo.getException().indexOf("driver on UnpooledDataSource") != -1) {
                    builder.append("Exception while initializing process engine! Database or database driver might not have been configured correctly.").append("Please consult the user guide for supported database environments or build.properties. Stacktrace: ").append(engineInfo.getException());
                } else {
                    builder.append("Stacktrace: ").append(engineInfo.getException());
                }
            } else {
                builder.append("Initialised");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getProcessEngineName() {
        return this.processEngineName;
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public void setFileSets(List<FileSet> fileSets) {
        this.fileSets = fileSets;
    }
}

