/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.operaton.bpm.engine.impl.ant.LaunchThread;

public class LaunchTask
extends Task {
    private static final String FILESEPARATOR = System.getProperty("file.separator");
    File dir;
    String script;
    String msg;
    String args;

    public void execute() throws BuildException {
        if (this.dir == null) {
            throw new BuildException("dir attribute is required with the launch task");
        }
        if (this.script == null) {
            throw new BuildException("script attribute is required with the launch task");
        }
        String[] cmd = null;
        String executable = this.getExecutable();
        if (this.args != null) {
            ArrayList<String> pieces = new ArrayList<String>();
            pieces.add(executable);
            StringTokenizer tokenizer = new StringTokenizer("args", " ");
            while (tokenizer.hasMoreTokens()) {
                pieces.add(tokenizer.nextToken());
            }
            cmd = pieces.toArray(new String[pieces.size()]);
        } else {
            cmd = new String[]{executable};
        }
        LaunchThread.launch(this, cmd, this.dir, this.msg);
    }

    public String getExecutable() {
        String os = System.getProperty("os.name").toLowerCase();
        String dirPath = this.dir.getAbsolutePath();
        String base = dirPath + FILESEPARATOR + this.script;
        if (this.exists(base)) {
            return base;
        }
        if (os.indexOf("windows") != -1) {
            if (this.exists(base + ".exe")) {
                return base + ".exe";
            }
            if (this.exists(base + ".bat")) {
                return base + ".bat";
            }
        }
        if ((os.indexOf("linux") != -1 || os.indexOf("mac") != -1) && this.exists(base + ".sh")) {
            return base + ".sh";
        }
        throw new BuildException("couldn't find executable for script " + base);
    }

    public boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setArgs(String args) {
        this.args = args;
    }
}

