/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import java.util.Map;
import java.util.concurrent.Callable;
import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.DelegateVariableMapping;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.core.model.BaseCallableElement;
import org.operaton.bpm.engine.impl.core.model.CallableElement;
import org.operaton.bpm.engine.impl.delegate.DelegateInvocation;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;
import org.operaton.bpm.engine.variable.VariableMap;

public abstract class CallableElementActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    protected String[] variablesFilter = new String[]{"nrOfInstances", "nrOfActiveInstances", "nrOfCompletedInstances"};
    protected CallableElement callableElement;
    protected Expression expression;
    protected String className;

    public CallableElementActivityBehavior() {
    }

    public CallableElementActivityBehavior(String className) {
        this.className = className;
    }

    public CallableElementActivityBehavior(Expression expression) {
        this.expression = expression;
    }

    protected DelegateVariableMapping getDelegateVariableMapping(Object instance) {
        if (instance instanceof DelegateVariableMapping) {
            return (DelegateVariableMapping)instance;
        }
        throw LOG.missingDelegateVariableMappingParentClassException(instance.getClass().getName(), DelegateVariableMapping.class.getName());
    }

    protected DelegateVariableMapping resolveDelegation(ActivityExecution execution) {
        Object delegate = this.resolveDelegateClass(execution);
        return delegate != null ? this.getDelegateVariableMapping(delegate) : null;
    }

    public Object resolveDelegateClass(final ActivityExecution execution) {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            return Context.executeWithinProcessApplication(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return CallableElementActivityBehavior.this.resolveDelegateClass(execution);
                }
            }, targetProcessApplication, new InvocationContext(execution));
        }
        return this.instantiateDelegateClass(execution);
    }

    protected Object instantiateDelegateClass(ActivityExecution execution) {
        Object delegate = null;
        if (this.expression != null) {
            delegate = this.expression.getValue(execution);
        } else if (this.className != null) {
            delegate = ClassDelegateUtil.instantiateDelegate(this.className, null);
        }
        return delegate;
    }

    @Override
    public void execute(final ActivityExecution execution) throws Exception {
        final VariableMap variables = this.getInputVariables(execution);
        final DelegateVariableMapping varMapping = this.resolveDelegation(execution);
        if (varMapping != null) {
            this.invokeVarMappingDelegation(new DelegateInvocation(execution, null){

                @Override
                protected void invoke() throws Exception {
                    varMapping.mapInputVariables(execution, variables);
                }
            });
        }
        String businessKey = this.getBusinessKey(execution);
        this.startInstance(execution, variables, businessKey);
    }

    @Override
    public void passOutputVariables(final ActivityExecution execution, final VariableScope subInstance) {
        VariableMap variables = this.filterVariables(this.getOutputVariables(subInstance));
        VariableMap localVariables = this.getOutputVariablesLocal(subInstance);
        execution.setVariables((Map<String, ? extends Object>)variables);
        execution.setVariablesLocal((Map<String, ? extends Object>)localVariables);
        final DelegateVariableMapping varMapping = this.resolveDelegation(execution);
        if (varMapping != null) {
            this.invokeVarMappingDelegation(new DelegateInvocation(execution, null){

                @Override
                protected void invoke() throws Exception {
                    varMapping.mapOutputVariables(execution, subInstance);
                }
            });
        }
    }

    protected void invokeVarMappingDelegation(DelegateInvocation delegation) {
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(delegation);
        }
        catch (Exception ex) {
            throw new ProcessEngineException(ex);
        }
    }

    protected VariableMap filterVariables(VariableMap variables) {
        if (variables != null) {
            for (String key : this.variablesFilter) {
                variables.remove((Object)key);
            }
        }
        return variables;
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    public CallableElement getCallableElement() {
        return this.callableElement;
    }

    public void setCallableElement(CallableElement callableElement) {
        this.callableElement = callableElement;
    }

    protected String getBusinessKey(ActivityExecution execution) {
        return this.getCallableElement().getBusinessKey(execution);
    }

    protected VariableMap getInputVariables(ActivityExecution callingExecution) {
        return this.getCallableElement().getInputVariables(callingExecution);
    }

    protected VariableMap getOutputVariables(VariableScope calledElementScope) {
        return this.getCallableElement().getOutputVariables(calledElementScope);
    }

    protected VariableMap getOutputVariablesLocal(VariableScope calledElementScope) {
        return this.getCallableElement().getOutputVariablesLocal(calledElementScope);
    }

    protected Integer getVersion(ActivityExecution execution) {
        return this.getCallableElement().getVersion(execution);
    }

    protected String getDeploymentId(ActivityExecution execution) {
        return this.getCallableElement().getDeploymentId();
    }

    protected BaseCallableElement.CallableElementBinding getBinding() {
        return this.getCallableElement().getBinding();
    }

    protected boolean isLatestBinding() {
        return this.getCallableElement().isLatestBinding();
    }

    protected boolean isDeploymentBinding() {
        return this.getCallableElement().isDeploymentBinding();
    }

    protected boolean isVersionBinding() {
        return this.getCallableElement().isVersionBinding();
    }

    protected abstract void startInstance(ActivityExecution var1, VariableMap var2, String var3);
}

