/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.engine.impl.Condition;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.PvmTransition;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.process.TransitionImpl;

public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    protected static BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        PvmActivity activity = execution.getActivity();
        if (this.activatesGateway(execution, activity)) {
            LOG.activityActivation(activity.getId());
            List<ActivityExecution> joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
            String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
            ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
            for (PvmTransition outgoingTransition : execution.getActivity().getOutgoingTransitions()) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && !condition.evaluate(execution)) continue;
                transitionsToTake.add(outgoingTransition);
            }
            if (transitionsToTake.isEmpty()) {
                if (defaultSequenceFlow != null) {
                    PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
                    if (defaultTransition == null) {
                        throw LOG.missingDefaultFlowException(execution.getActivity().getId(), defaultSequenceFlow);
                    }
                    transitionsToTake.add(defaultTransition);
                } else {
                    throw LOG.stuckExecutionException(execution.getActivity().getId());
                }
            }
            execution.leaveActivityViaTransitions(transitionsToTake, joinedExecutions);
        } else {
            LOG.noActivityActivation(activity.getId());
        }
    }

    protected Collection<ActivityExecution> getLeafExecutions(ActivityExecution parent) {
        ArrayList<ActivityExecution> executionlist = new ArrayList<ActivityExecution>();
        List<? extends ActivityExecution> subExecutions = parent.getNonEventScopeExecutions();
        if (subExecutions.size() == 0) {
            executionlist.add(parent);
        } else {
            for (ActivityExecution activityExecution : subExecutions) {
                executionlist.addAll(this.getLeafExecutions(activityExecution));
            }
        }
        return executionlist;
    }

    protected boolean activatesGateway(ActivityExecution execution, PvmActivity gatewayActivity) {
        int numExecutionsGuaranteedToActivate = gatewayActivity.getIncomingTransitions().size();
        ActivityExecution scopeExecution = execution.isScope() ? execution : execution.getParent();
        List<ActivityExecution> executionsAtGateway = execution.findInactiveConcurrentExecutions(gatewayActivity);
        if (executionsAtGateway.size() >= numExecutionsGuaranteedToActivate) {
            return true;
        }
        Collection<ActivityExecution> executionsNotAtGateway = this.getLeafExecutions(scopeExecution);
        executionsNotAtGateway.removeAll(executionsAtGateway);
        for (ActivityExecution executionNotAtGateway : executionsNotAtGateway) {
            if (!this.canReachActivity(executionNotAtGateway, gatewayActivity)) continue;
            return false;
        }
        return true;
    }

    protected boolean canReachActivity(ActivityExecution execution, PvmActivity activity) {
        TransitionImpl pvmTransition = execution.getTransition();
        if (pvmTransition != null) {
            return this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>());
        }
        return this.isReachable(execution.getActivity(), activity, new HashSet<PvmActivity>());
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.equals(targetActivity)) {
            return true;
        }
        if (visitedActivities.contains(srcActivity)) {
            return false;
        }
        visitedActivities.add(srcActivity);
        List<PvmTransition> outgoingTransitions = srcActivity.getOutgoingTransitions();
        if (outgoingTransitions.isEmpty()) {
            if (srcActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                ActivityImpl eventBasedGateway = (ActivityImpl)srcActivity;
                Set<ActivityImpl> eventActivities = eventBasedGateway.getEventActivities();
                for (ActivityImpl eventActivity : eventActivities) {
                    boolean isReachable = this.isReachable(eventActivity, targetActivity, visitedActivities);
                    if (!isReachable) continue;
                    return true;
                }
            } else {
                ScopeImpl flowScope = srcActivity.getFlowScope();
                if (flowScope != null && flowScope instanceof PvmActivity) {
                    return this.isReachable((PvmActivity)((Object)flowScope), targetActivity, visitedActivities);
                }
            }
            return false;
        }
        for (PvmTransition pvmTransition : outgoingTransitions) {
            boolean reachable;
            PvmActivity destinationActivity = pvmTransition.getDestination();
            if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
            return true;
        }
        return false;
    }
}

