/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.delegate.JavaDelegate;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.delegate.ActivityBehaviorInvocation;
import org.operaton.bpm.engine.impl.bpmn.delegate.JavaDelegateInvocation;
import org.operaton.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ServiceTaskDelegateExpressionActivityBehavior.this.signal(execution, signalName, signalData);
                    return null;
                }
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    public void doSignal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegateActivityBehavior;
        Object delegate = this.expression.getValue(execution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        final ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution, delegate);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegateActivityBehavior = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            return;
        }
        this.executeWithErrorPropagation(execution, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
                return null;
            }
        });
    }

    @Override
    public void performExecution(final ActivityExecution execution) throws Exception {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Object delegate = ServiceTaskDelegateExpressionActivityBehavior.this.expression.getValue(execution);
                ClassDelegateUtil.applyFieldDeclaration(ServiceTaskDelegateExpressionActivityBehavior.this.fieldDeclarations, delegate);
                if (delegate instanceof ActivityBehavior) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)delegate, execution));
                } else if (delegate instanceof JavaDelegate) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
                    ServiceTaskDelegateExpressionActivityBehavior.this.leave(execution);
                } else {
                    throw LOG.resolveDelegateExpressionException(ServiceTaskDelegateExpressionActivityBehavior.this.expression, ActivityBehavior.class, JavaDelegate.class);
                }
                return null;
            }
        };
        this.executeWithErrorPropagation(execution, callable);
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution, Object delegateInstance) {
        if (delegateInstance instanceof ActivityBehavior) {
            return new CustomActivityBehavior((ActivityBehavior)delegateInstance);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), JavaDelegate.class.getName(), ActivityBehavior.class.getName());
    }
}

