/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractDeleteProcessDefinitionCmd
implements Command<Void>,
Serializable {
    protected boolean cascade;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    protected void deleteProcessDefinitionCmd(CommandContext commandContext, String processDefinitionId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        ProcessDefinitionEntity processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        List<CommandChecker> commandCheckers = commandContext.getProcessEngineConfiguration().getCommandCheckers();
        for (CommandChecker checker : commandCheckers) {
            checker.checkDeleteProcessDefinitionById(processDefinitionId);
        }
        UserOperationLogManager userOperationLogManager = commandContext.getOperationLogManager();
        userOperationLogManager.logProcessDefinitionOperation("Delete", processDefinitionId, processDefinition.getKey(), new PropertyChange("cascade", false, cascade));
        ProcessDefinitionManager definitionManager = commandContext.getProcessDefinitionManager();
        definitionManager.deleteProcessDefinition(processDefinition, processDefinitionId, cascade, cascade, skipCustomListeners, skipIoMappings);
    }
}

