/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.TaskEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TaskManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class DeleteIdentityLinkCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String groupId;
    protected String type;
    protected String taskId;
    protected TaskEntity task;

    public DeleteIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        EnsureUtil.ensureNotNull("taskId", (Object)taskId);
        EnsureUtil.ensureNotNull("type is required when adding a new task identity link", "type", (Object)type);
        if ("assignee".equals(type) || "owner".equals(type)) {
            if (groupId != null) {
                throw new ProcessEngineException("Incompatible usage: cannot use type '" + type + "' together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ProcessEngineException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        this.task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)this.task);
        this.checkDeleteIdentityLink(this.task, commandContext);
        if ("assignee".equals(this.type)) {
            this.task.setAssignee(null);
        } else if ("owner".equals(this.type)) {
            this.task.setOwner(null);
        } else {
            this.task.deleteIdentityLink(this.userId, this.groupId, this.type);
        }
        this.task.triggerUpdateEvent();
        return null;
    }

    protected void checkDeleteIdentityLink(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskAssign(task);
        }
    }
}

