/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.impl.ManagementServiceImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.operaton.bpm.engine.impl.cmd.LicenseCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyManager;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceManager;

public class DeleteLicenseKeyCmd
extends LicenseCmd
implements Command<Object> {
    boolean deleteProperty;
    boolean updateTelemetry;

    public DeleteLicenseKeyCmd(boolean deleteProperty) {
        this(deleteProperty, true);
    }

    public DeleteLicenseKeyCmd(boolean deleteProperty, boolean updateTelemetry) {
        this.deleteProperty = deleteProperty;
        this.updateTelemetry = updateTelemetry;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkDeleteLicenseKey);
        ResourceManager resourceManager = commandContext.getResourceManager();
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity licenseProperty = propertyManager.findPropertyById("operaton-license-key-id");
        ResourceEntity licenseKey = resourceManager.findLicenseKeyResource();
        if (licenseKey != null) {
            resourceManager.delete(licenseKey);
        }
        new DeletePropertyCmd("operaton-license-key").execute(commandContext);
        if (this.deleteProperty) {
            new DeletePropertyCmd("operaton-license-key-id").execute(commandContext);
        }
        if (this.updateTelemetry) {
            ((ManagementServiceImpl)commandContext.getProcessEngineConfiguration().getManagementService()).setLicenseKeyForTelemetry(null);
        }
        return null;
    }
}

