/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.ConditionEvaluationBuilderImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.runtime.ConditionHandler;
import org.operaton.bpm.engine.impl.runtime.ConditionHandlerResult;
import org.operaton.bpm.engine.impl.runtime.ConditionSet;
import org.operaton.bpm.engine.runtime.ProcessInstance;

public class EvaluateStartConditionCmd
implements Command<List<ProcessInstance>> {
    protected ConditionEvaluationBuilderImpl builder;

    public EvaluateStartConditionCmd(ConditionEvaluationBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public List<ProcessInstance> execute(CommandContext commandContext) {
        ConditionHandler conditionHandler = commandContext.getProcessEngineConfiguration().getConditionHandler();
        ConditionSet conditionSet = new ConditionSet(this.builder);
        List<ConditionHandlerResult> results = conditionHandler.evaluateStartCondition(commandContext, conditionSet);
        for (ConditionHandlerResult ConditionHandlerResult2 : results) {
            this.checkAuthorization(commandContext, ConditionHandlerResult2);
        }
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (ConditionHandlerResult ConditionHandlerResult3 : results) {
            processInstances.add(this.instantiateProcess(commandContext, ConditionHandlerResult3));
        }
        return processInstances;
    }

    protected void checkAuthorization(CommandContext commandContext, ConditionHandlerResult result) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            ProcessDefinitionEntity definition = result.getProcessDefinition();
            checker.checkCreateProcessInstance(definition);
        }
    }

    protected ProcessInstance instantiateProcess(CommandContext commandContext, ConditionHandlerResult result) {
        ProcessDefinitionEntity processDefinitionEntity = result.getProcessDefinition();
        ActivityImpl startEvent = processDefinitionEntity.findActivity(result.getActivity().getActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.builder.getBusinessKey(), startEvent);
        processInstance.start((Map<String, Object>)this.builder.getVariables());
        return processInstance;
    }
}

