/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TransitionInstanceImpl;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ActivityInstance;
import org.operaton.bpm.engine.runtime.Incident;

public class GetActivityInstanceCmd
implements Command<ActivityInstance> {
    protected String processInstanceId;

    public GetActivityInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ActivityInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
        List<ExecutionEntity> executionList = this.loadProcessInstance(this.processInstanceId, commandContext);
        if (executionList.isEmpty()) {
            return null;
        }
        this.checkGetActivityInstance(this.processInstanceId, commandContext);
        List<ExecutionEntity> nonEventScopeExecutions = this.filterNonEventScopeExecutions(executionList);
        List<ExecutionEntity> leaves = this.filterLeaves(nonEventScopeExecutions);
        this.orderById(leaves);
        ExecutionEntity processInstance = this.filterProcessInstance(executionList);
        if (processInstance.isEnded()) {
            return null;
        }
        Map<String, List<Incident>> incidents = this.groupIncidentIdsByExecutionId(commandContext);
        ActivityInstanceImpl processActInst = this.createActivityInstance(processInstance, processInstance.getProcessDefinition(), this.processInstanceId, null, incidents);
        HashMap<String, ActivityInstanceImpl> activityInstances = new HashMap<String, ActivityInstanceImpl>();
        activityInstances.put(this.processInstanceId, processActInst);
        HashMap<String, TransitionInstanceImpl> transitionInstances = new HashMap<String, TransitionInstanceImpl>();
        for (ExecutionEntity leaf : leaves) {
            if (leaf.getActivity() == null) continue;
            Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = leaf.createActivityExecutionMapping();
            HashMap<ScopeImpl, PvmExecutionImpl> scopeInstancesToCreate = new HashMap<ScopeImpl, PvmExecutionImpl>(activityExecutionMapping);
            if (leaf.getActivityInstanceId() != null) {
                if (!CompensationBehavior.isCompensationThrowing(leaf) || LegacyBehavior.isCompensationThrowing(leaf, activityExecutionMapping)) {
                    String parentActivityInstanceId = null;
                    parentActivityInstanceId = activityExecutionMapping.get(leaf.getActivity().getFlowScope()).getParentActivityInstanceId();
                    ActivityInstanceImpl leafInstance = this.createActivityInstance(leaf, leaf.getActivity(), leaf.getActivityInstanceId(), parentActivityInstanceId, incidents);
                    activityInstances.put(leafInstance.getId(), leafInstance);
                    scopeInstancesToCreate.remove(leaf.getActivity());
                }
            } else {
                TransitionInstanceImpl transitionInstance = this.createTransitionInstance(leaf, incidents);
                transitionInstances.put(transitionInstance.getId(), transitionInstance);
                scopeInstancesToCreate.remove(leaf.getActivity());
            }
            LegacyBehavior.removeLegacyNonScopesFromMapping(scopeInstancesToCreate);
            scopeInstancesToCreate.remove(leaf.getProcessDefinition());
            for (Map.Entry scopeExecutionEntry : scopeInstancesToCreate.entrySet()) {
                ScopeImpl scope = (ScopeImpl)scopeExecutionEntry.getKey();
                PvmExecutionImpl scopeExecution = (PvmExecutionImpl)scopeExecutionEntry.getValue();
                String activityInstanceId = null;
                String parentActivityInstanceId = null;
                activityInstanceId = scopeExecution.getParentActivityInstanceId();
                parentActivityInstanceId = activityExecutionMapping.get(scope.getFlowScope()).getParentActivityInstanceId();
                if (activityInstances.containsKey(activityInstanceId)) continue;
                ActivityInstanceImpl scopeInstance = this.createActivityInstance(scopeExecution, scope, activityInstanceId, parentActivityInstanceId, incidents);
                activityInstances.put(activityInstanceId, scopeInstance);
            }
        }
        LegacyBehavior.repairParentRelationships(activityInstances.values(), this.processInstanceId);
        this.populateChildInstances(activityInstances, transitionInstances);
        return processActInst;
    }

    protected void checkGetActivityInstance(String processInstanceId, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstance(processInstanceId);
        }
    }

    protected void orderById(List<ExecutionEntity> leaves) {
        Collections.sort(leaves, ExecutionIdComparator.INSTANCE);
    }

    protected ActivityInstanceImpl createActivityInstance(PvmExecutionImpl scopeExecution, ScopeImpl scope, String activityInstanceId, String parentActivityInstanceId, Map<String, List<Incident>> incidentsByExecution) {
        ActivityInstanceImpl actInst = new ActivityInstanceImpl();
        actInst.setId(activityInstanceId);
        actInst.setParentActivityInstanceId(parentActivityInstanceId);
        actInst.setProcessInstanceId(scopeExecution.getProcessInstanceId());
        actInst.setProcessDefinitionId(scopeExecution.getProcessDefinitionId());
        actInst.setBusinessKey(scopeExecution.getBusinessKey());
        actInst.setActivityId(scope.getId());
        String name = scope.getName();
        if (name == null) {
            name = (String)scope.getProperty("name");
        }
        actInst.setActivityName(name);
        if (scope.getId().equals(scopeExecution.getProcessDefinition().getId())) {
            actInst.setActivityType("processDefinition");
        } else {
            actInst.setActivityType((String)scope.getProperty("type"));
        }
        ArrayList<String> executionIds = new ArrayList<String>();
        ArrayList<String> incidentIds = new ArrayList<String>();
        ArrayList<Incident> incidents = new ArrayList<Incident>();
        executionIds.add(scopeExecution.getId());
        ActivityImpl executionActivity = scopeExecution.getActivity();
        if (executionActivity == null || executionActivity == scope) {
            incidentIds.addAll(this.getIncidentIds(incidentsByExecution, scopeExecution));
            incidents.addAll(this.getIncidents(incidentsByExecution, scopeExecution));
        }
        for (PvmExecutionImpl pvmExecutionImpl : scopeExecution.getNonEventScopeExecutions()) {
            if (!pvmExecutionImpl.isConcurrent() || pvmExecutionImpl.getActivityId() != null) continue;
            executionIds.add(pvmExecutionImpl.getId());
            incidentIds.addAll(this.getIncidentIds(incidentsByExecution, pvmExecutionImpl));
            incidents.addAll(this.getIncidents(incidentsByExecution, pvmExecutionImpl));
        }
        actInst.setExecutionIds(executionIds.toArray(new String[executionIds.size()]));
        actInst.setIncidentIds(incidentIds.toArray(new String[incidentIds.size()]));
        actInst.setIncidents(incidents.toArray(new Incident[0]));
        return actInst;
    }

    protected TransitionInstanceImpl createTransitionInstance(PvmExecutionImpl execution, Map<String, List<Incident>> incidentsByExecution) {
        TransitionInstanceImpl transitionInstance = new TransitionInstanceImpl();
        transitionInstance.setId(execution.getId());
        transitionInstance.setParentActivityInstanceId(execution.getParentActivityInstanceId());
        transitionInstance.setProcessInstanceId(execution.getProcessInstanceId());
        transitionInstance.setProcessDefinitionId(execution.getProcessDefinitionId());
        transitionInstance.setExecutionId(execution.getId());
        transitionInstance.setActivityId(execution.getActivityId());
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            String name = activity.getName();
            if (name == null) {
                name = (String)activity.getProperty("name");
            }
            transitionInstance.setActivityName(name);
            transitionInstance.setActivityType((String)activity.getProperty("type"));
        }
        List<String> incidentIdList = this.getIncidentIds(incidentsByExecution, execution);
        List<Incident> incidents = this.getIncidents(incidentsByExecution, execution);
        transitionInstance.setIncidentIds(incidentIdList.toArray(new String[0]));
        transitionInstance.setIncidents(incidents.toArray(new Incident[0]));
        return transitionInstance;
    }

    protected void populateChildInstances(Map<String, ActivityInstanceImpl> activityInstances, Map<String, TransitionInstanceImpl> transitionInstances) {
        List childInstances;
        ActivityInstanceImpl instance;
        ActivityInstanceImpl parentInstance;
        HashMap childActivityInstances = new HashMap();
        HashMap childTransitionInstances = new HashMap();
        for (ActivityInstanceImpl activityInstanceImpl : activityInstances.values()) {
            if (activityInstanceImpl.getParentActivityInstanceId() == null) continue;
            parentInstance = activityInstances.get(activityInstanceImpl.getParentActivityInstanceId());
            if (parentInstance == null) {
                throw new ProcessEngineException("No parent activity instance with id " + activityInstanceImpl.getParentActivityInstanceId() + " generated");
            }
            this.putListElement(childActivityInstances, parentInstance, activityInstanceImpl);
        }
        for (TransitionInstanceImpl transitionInstanceImpl : transitionInstances.values()) {
            if (transitionInstanceImpl.getParentActivityInstanceId() == null) continue;
            parentInstance = activityInstances.get(transitionInstanceImpl.getParentActivityInstanceId());
            if (parentInstance == null) {
                throw new ProcessEngineException("No parent activity instance with id " + transitionInstanceImpl.getParentActivityInstanceId() + " generated");
            }
            this.putListElement(childTransitionInstances, parentInstance, transitionInstanceImpl);
        }
        for (Map.Entry entry : childActivityInstances.entrySet()) {
            instance = (ActivityInstanceImpl)entry.getKey();
            childInstances = (List)entry.getValue();
            if (childInstances == null) continue;
            instance.setChildActivityInstances(childInstances.toArray(new ActivityInstanceImpl[childInstances.size()]));
        }
        for (Map.Entry entry : childTransitionInstances.entrySet()) {
            instance = (ActivityInstanceImpl)entry.getKey();
            childInstances = (List)entry.getValue();
            if (childTransitionInstances == null) continue;
            instance.setChildTransitionInstances(childInstances.toArray(new TransitionInstanceImpl[childInstances.size()]));
        }
    }

    protected <S, T> void putListElement(Map<S, List<T>> mapOfLists, S key, T listElement) {
        List<T> list = mapOfLists.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            mapOfLists.put(key, list);
        }
        list.add(listElement);
    }

    protected ExecutionEntity filterProcessInstance(List<ExecutionEntity> executionList) {
        for (ExecutionEntity execution : executionList) {
            if (!execution.isProcessInstanceExecution()) continue;
            return execution;
        }
        throw new ProcessEngineException("Could not determine process instance execution");
    }

    protected List<ExecutionEntity> filterLeaves(List<ExecutionEntity> executionList) {
        ArrayList<ExecutionEntity> leaves = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executionList) {
            if (!execution.getNonEventScopeExecutions().isEmpty() && !CompensationBehavior.isCompensationThrowing(execution)) continue;
            leaves.add(execution);
        }
        return leaves;
    }

    protected List<ExecutionEntity> filterNonEventScopeExecutions(List<ExecutionEntity> executionList) {
        ArrayList<ExecutionEntity> nonEventScopeExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executionList) {
            if (execution.isEventScope()) continue;
            nonEventScopeExecutions.add(execution);
        }
        return nonEventScopeExecutions;
    }

    protected List<ExecutionEntity> loadProcessInstance(String processInstanceId, CommandContext commandContext) {
        List<ExecutionEntity> result = null;
        List<ExecutionEntity> cachedExecutions = commandContext.getDbEntityManager().getCachedEntitiesByType(ExecutionEntity.class);
        for (ExecutionEntity executionEntity : cachedExecutions) {
            if (!processInstanceId.equals(executionEntity.getProcessInstanceId())) continue;
            result = new ArrayList<ExecutionEntity>();
            ExecutionEntity processInstance = executionEntity.getProcessInstance();
            result.add(processInstance);
            this.loadChildExecutionsFromCache(processInstance, result);
            break;
        }
        if (result == null) {
            result = this.loadFromDb(processInstanceId, commandContext);
        }
        return result;
    }

    protected List<ExecutionEntity> loadFromDb(String processInstanceId, CommandContext commandContext) {
        List<ExecutionEntity> executions = commandContext.getExecutionManager().findExecutionsByProcessInstanceId(processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        if (processInstance != null) {
            processInstance.restoreProcessInstance(executions, null, null, null, null, null, null);
        }
        return executions;
    }

    protected void loadChildExecutionsFromCache(ExecutionEntity execution, List<ExecutionEntity> childExecutions) {
        List<ExecutionEntity> childrenOfThisExecution = execution.getExecutions();
        if (childrenOfThisExecution != null) {
            childExecutions.addAll(childrenOfThisExecution);
            for (ExecutionEntity child : childrenOfThisExecution) {
                this.loadChildExecutionsFromCache(child, childExecutions);
            }
        }
    }

    protected Map<String, List<Incident>> groupIncidentIdsByExecutionId(CommandContext commandContext) {
        List<IncidentEntity> incidents = commandContext.getIncidentManager().findIncidentsByProcessInstance(this.processInstanceId);
        HashMap<String, List<Incident>> result = new HashMap<String, List<Incident>>();
        for (IncidentEntity incidentEntity : incidents) {
            CollectionUtil.addToMapOfLists(result, incidentEntity.getExecutionId(), incidentEntity);
        }
        return result;
    }

    protected List<String> getIncidentIds(Map<String, List<Incident>> incidents, PvmExecutionImpl execution) {
        ArrayList<String> incidentIds = new ArrayList<String>();
        List<Incident> incidentList = incidents.get(execution.getId());
        if (incidentList != null) {
            for (Incident incident : incidentList) {
                incidentIds.add(incident.getId());
            }
            return incidentIds;
        }
        return Collections.emptyList();
    }

    protected List<Incident> getIncidents(Map<String, List<Incident>> incidents, PvmExecutionImpl execution) {
        List<Incident> incidentList = incidents.get(execution.getId());
        if (incidentList != null) {
            return incidentList;
        }
        return Collections.emptyList();
    }

    public static class ExecutionIdComparator
    implements Comparator<ExecutionEntity> {
        public static final ExecutionIdComparator INSTANCE = new ExecutionIdComparator();

        @Override
        public int compare(ExecutionEntity o1, ExecutionEntity o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

