/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.form.OperatonFormRef;
import org.operaton.bpm.engine.impl.form.entity.OperatonFormDefinitionManager;
import org.operaton.bpm.engine.impl.form.handler.DefaultFormHandler;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import org.operaton.bpm.engine.repository.OperatonFormDefinition;

public class GetOperatonFormDefinitionCmd
implements Command<OperatonFormDefinition> {
    protected OperatonFormRef operatonFormRef;
    protected String deploymentId;

    public GetOperatonFormDefinitionCmd(OperatonFormRef operatonFormRef, String deploymentId) {
        this.operatonFormRef = operatonFormRef;
        this.deploymentId = deploymentId;
    }

    @Override
    public OperatonFormDefinition execute(CommandContext commandContext) {
        String binding = this.operatonFormRef.getBinding();
        String key = this.operatonFormRef.getKey();
        OperatonFormDefinitionEntity definition = null;
        OperatonFormDefinitionManager manager = commandContext.getOperatonFormDefinitionManager();
        if (binding.equals("deployment")) {
            definition = manager.findDefinitionByDeploymentAndKey(this.deploymentId, key);
        } else if (binding.equals("latest")) {
            definition = manager.findLatestDefinitionByKey(key);
        } else if (binding.equals("version")) {
            definition = manager.findDefinitionByKeyVersionAndTenantId(key, this.operatonFormRef.getVersion(), null);
        } else {
            throw new BadUserRequestException("Unsupported binding type for operatonFormRef. Expected to be one of " + DefaultFormHandler.ALLOWED_FORM_REF_BINDINGS + " but was:" + binding);
        }
        return definition;
    }
}

