/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.exception.NotFoundException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.operaton.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.operaton.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.TimerEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class RecalculateJobDuedateCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private boolean creationDateBased;

    public RecalculateJobDuedateCmd(String jobId, boolean creationDateBased) {
        EnsureUtil.ensureNotEmpty("The job id is mandatory", "jobId", jobId);
        this.jobId = jobId;
        this.creationDateBased = creationDateBased;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No job found with id '" + this.jobId + "'", "job", (Object)job);
        this.checkJobType(job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateJob(job);
        }
        final TimerDeclarationImpl timerDeclaration = this.findTimerDeclaration(commandContext, job);
        final TimerEntity timer = (TimerEntity)job;
        Date oldDuedate = job.getDuedate();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                timerDeclaration.resolveAndSetDuedate(timer.getExecution(), timer, RecalculateJobDuedateCmd.this.creationDateBased);
            }
        };
        ProcessDefinitionEntity contextDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(job.getProcessDefinitionId());
        ProcessApplicationContextUtil.doContextSwitch(runnable, contextDefinition);
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("duedate", oldDuedate, job.getDuedate()));
        propertyChanges.add(new PropertyChange("creationDateBased", null, this.creationDateBased));
        commandContext.getOperationLogManager().logJobOperation("RecalculateDueDate", this.jobId, job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), propertyChanges);
        return null;
    }

    protected void checkJobType(JobEntity job) {
        String type = job.getJobHandlerType();
        if (!(("timer-transition".equals(type) || "timer-intermediate-transition".equals(type) || "timer-start-event".equals(type) || "timer-start-event-subprocess".equals(type) || "timer-task-listener".equals(type)) && job instanceof TimerEntity)) {
            throw new ProcessEngineException("Only timer jobs can be recalculated, but the job with id '" + this.jobId + "' is of type '" + type + "'.");
        }
    }

    protected TimerDeclarationImpl findTimerDeclaration(CommandContext commandContext, JobEntity job) {
        TimerDeclarationImpl timerDeclaration = null;
        timerDeclaration = job.getExecutionId() != null ? this.findTimerDeclarationForActivity(commandContext, job) : this.findTimerDeclarationForProcessStartEvent(commandContext, job);
        if (timerDeclaration == null) {
            throw new ProcessEngineException("No timer declaration found for job id '" + this.jobId + "'.");
        }
        return timerDeclaration;
    }

    protected TimerDeclarationImpl findTimerDeclarationForActivity(CommandContext commandContext, JobEntity job) {
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(job.getExecutionId());
        if (execution == null) {
            throw new ProcessEngineException("No execution found with id '" + job.getExecutionId() + "' for job id '" + this.jobId + "'.");
        }
        ActivityImpl activity = execution.getProcessDefinition().findActivity(job.getActivityId());
        if (activity != null) {
            if ("timer-task-listener".equals(job.getJobHandlerType())) {
                return this.findTimeoutListenerDeclaration(job, activity);
            }
            Map<String, TimerDeclarationImpl> timerDeclarations = TimerDeclarationImpl.getDeclarationsForScope(activity.getEventScope());
            if (!timerDeclarations.isEmpty() && timerDeclarations.containsKey(job.getActivityId())) {
                return timerDeclarations.get(job.getActivityId());
            }
        }
        return null;
    }

    protected TimerDeclarationImpl findTimeoutListenerDeclaration(JobEntity job, ActivityImpl activity) {
        JobHandlerConfiguration jobHandlerConfiguration;
        Map<String, TimerDeclarationImpl> activityTimeouts;
        Map<String, Map<String, TimerDeclarationImpl>> timeoutDeclarations = TimerDeclarationImpl.getTimeoutListenerDeclarationsForScope(activity.getEventScope());
        if (!timeoutDeclarations.isEmpty() && (activityTimeouts = timeoutDeclarations.get(job.getActivityId())) != null && !activityTimeouts.isEmpty() && (jobHandlerConfiguration = job.getJobHandlerConfiguration()) instanceof TimerEventJobHandler.TimerJobConfiguration) {
            return activityTimeouts.get(((TimerEventJobHandler.TimerJobConfiguration)jobHandlerConfiguration).getTimerElementSecondaryKey());
        }
        return null;
    }

    protected TimerDeclarationImpl findTimerDeclarationForProcessStartEvent(CommandContext commandContext, JobEntity job) {
        ProcessDefinitionEntity processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(job.getProcessDefinitionId());
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        for (TimerDeclarationImpl timerDeclarationCandidate : timerDeclarations) {
            if (!timerDeclarationCandidate.getJobDefinitionId().equals(job.getJobDefinitionId())) continue;
            return timerDeclarationCandidate;
        }
        return null;
    }
}

