/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SaveAuthorizationCmd
implements Command<Authorization> {
    protected AuthorizationEntity authorization;

    public SaveAuthorizationCmd(Authorization authorization) {
        this.authorization = (AuthorizationEntity)authorization;
        this.validate();
    }

    protected void validate() {
        EnsureUtil.ensureOnlyOneNotNull("Authorization must either have a 'userId' or a 'groupId'.", this.authorization.getUserId(), this.authorization.getGroupId());
        EnsureUtil.ensureNotNull("Authorization 'resourceType' cannot be null.", "authorization.getResource()", (Object)this.authorization.getResource());
    }

    @Override
    public Authorization execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.validateResourceCompatibility(this.authorization);
        this.provideRemovalTime(commandContext);
        String operationType = null;
        AuthorizationEntity previousValues = null;
        if (this.authorization.getId() == null) {
            authorizationManager.insert(this.authorization);
            operationType = "Create";
        } else {
            previousValues = commandContext.getDbEntityManager().selectById(AuthorizationEntity.class, this.authorization.getId());
            authorizationManager.update(this.authorization);
            operationType = "Update";
        }
        commandContext.getOperationLogManager().logAuthorizationOperation(operationType, this.authorization, previousValues);
        return this.authorization;
    }

    protected void provideRemovalTime(CommandContext commandContext) {
        for (Map.Entry<Resources, Supplier<HistoryEvent>> resourceEntry : this.getHistoricInstanceResources(commandContext)) {
            Resources resource = resourceEntry.getKey();
            if (!this.isResourceEqualTo(resource)) continue;
            Supplier<HistoryEvent> historyEventSupplier = resourceEntry.getValue();
            HistoryEvent historyEvent = historyEventSupplier.get();
            this.provideRemovalTime(historyEvent);
            break;
        }
    }

    protected Set<Map.Entry<Resources, Supplier<HistoryEvent>>> getHistoricInstanceResources(CommandContext commandContext) {
        HashMap<Resources, Supplier<HistoryEvent>> resources = new HashMap<Resources, Supplier<HistoryEvent>>();
        resources.put(Resources.HISTORIC_PROCESS_INSTANCE, () -> this.getHistoricProcessInstance(commandContext));
        resources.put(Resources.HISTORIC_TASK, () -> this.getHistoricTaskInstance(commandContext));
        return resources.entrySet();
    }

    protected void provideRemovalTime(HistoryEvent historicInstance) {
        if (historicInstance != null) {
            String rootProcessInstanceId = historicInstance.getRootProcessInstanceId();
            this.authorization.setRootProcessInstanceId(rootProcessInstanceId);
            Date removalTime = historicInstance.getRemovalTime();
            this.authorization.setRemovalTime(removalTime);
        } else {
            this.authorization.setRootProcessInstanceId(null);
            this.authorization.setRemovalTime(null);
        }
    }

    protected HistoryEvent getHistoricProcessInstance(CommandContext commandContext) {
        String historicProcessInstanceId = this.authorization.getResourceId();
        if (this.isNullOrAny(historicProcessInstanceId)) {
            return null;
        }
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(historicProcessInstanceId);
    }

    protected HistoryEvent getHistoricTaskInstance(CommandContext commandContext) {
        String historicTaskInstanceId = this.authorization.getResourceId();
        if (this.isNullOrAny(historicTaskInstanceId)) {
            return null;
        }
        return commandContext.getHistoricTaskInstanceManager().findHistoricTaskInstanceById(historicTaskInstanceId);
    }

    protected boolean isNullOrAny(String resourceId) {
        return resourceId == null || this.isAny(resourceId);
    }

    protected boolean isAny(String resourceId) {
        return Objects.equals("*", resourceId);
    }

    protected boolean isResourceEqualTo(Resources resource) {
        return Objects.equals(resource.resourceType(), this.authorization.getResource());
    }
}

