/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.cmd.ExternalTaskCmd;
import org.operaton.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SetExternalTaskRetriesCmd
extends ExternalTaskCmd {
    protected int retries;
    protected boolean writeUserOperationLog;

    public SetExternalTaskRetriesCmd(String externalTaskId, int retries, boolean writeUserOperationLog) {
        super(externalTaskId);
        this.retries = retries;
        this.writeUserOperationLog = writeUserOperationLog;
    }

    @Override
    protected void validateInput() {
        EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "The number of retries cannot be negative", "retries", this.retries, 0L);
    }

    @Override
    protected void execute(ExternalTaskEntity externalTask) {
        externalTask.setRetriesAndManageIncidents(this.retries);
    }

    @Override
    protected String getUserOperationLogOperationType() {
        if (this.writeUserOperationLog) {
            return "SetExternalTaskRetries";
        }
        return super.getUserOperationLogOperationType();
    }

    @Override
    protected List<PropertyChange> getUserOperationLogPropertyChanges(ExternalTaskEntity externalTask) {
        if (this.writeUserOperationLog) {
            return Collections.singletonList(new PropertyChange("retries", externalTask.getRetries(), this.retries));
        }
        return super.getUserOperationLogPropertyChanges(externalTask);
    }
}

