/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.nio.charset.StandardCharsets;
import org.operaton.bpm.engine.impl.ManagementServiceImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.DeleteLicenseKeyCmd;
import org.operaton.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.operaton.bpm.engine.impl.cmd.LicenseCmd;
import org.operaton.bpm.engine.impl.cmd.SetPropertyCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceManager;
import org.operaton.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SetLicenseKeyCmd
extends LicenseCmd
implements Command<Object> {
    protected String licenseKey;

    public SetLicenseKeyCmd(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("licenseKey", (Object)this.licenseKey);
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkSetLicenseKey);
        ResourceManager resourceManager = commandContext.getResourceManager();
        ResourceEntity key = resourceManager.findLicenseKeyResource();
        if (key != null) {
            new DeleteLicenseKeyCmd(false, false).execute(commandContext);
        }
        key = new ResourceEntity();
        key.setName("operaton-license-key");
        key.setBytes(this.licenseKey.getBytes(StandardCharsets.UTF_8));
        resourceManager.insertResource(key);
        commandContext.runWithoutAuthorization(new SetPropertyCmd("operaton-license-key-id", key.getId()));
        commandContext.runWithoutAuthorization(new DeletePropertyCmd("operaton-license-key"));
        ManagementServiceImpl managementService = (ManagementServiceImpl)commandContext.getProcessEngineConfiguration().getManagementService();
        LicenseKeyDataImpl currentLicenseData = managementService.getLicenseKeyFromTelemetry();
        LicenseKeyDataImpl licenseKeyData = LicenseKeyDataImpl.fromRawString(this.licenseKey);
        if (currentLicenseData == null || !licenseKeyData.getRaw().equals(currentLicenseData.getRaw())) {
            managementService.setLicenseKeyForTelemetry(licenseKeyData);
        }
        return null;
    }
}

