/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateBatchConfiguration;
import org.operaton.bpm.engine.impl.cmd.AbstractUpdateProcessInstancesSuspendStateCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class UpdateProcessInstancesSuspendStateBatchCmd
extends AbstractUpdateProcessInstancesSuspendStateCmd<Batch> {
    public UpdateProcessInstancesSuspendStateBatchCmd(CommandExecutor commandExecutor, UpdateProcessInstancesSuspensionStateBuilderImpl builder, boolean suspending) {
        super(commandExecutor, builder, suspending);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "No process instance ids given", "process Instance Ids", elementConfiguration.getIds());
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Cannot be null.", "Process Instance ids", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("instance-update-suspension-state").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_UPDATE_PROCESS_INSTANCES_SUSPEND).operationLogHandler(this::writeUserOperationLogAsync).build();
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new UpdateProcessInstancesSuspendStateBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.suspending);
    }
}

