/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.history.HistoricProcessInstanceQuery;
import org.operaton.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.MessageCorrelationAsyncBuilderImpl;
import org.operaton.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.batch.message.MessageCorrelationBatchConfiguration;
import org.operaton.bpm.engine.impl.core.variable.VariableUtil;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ProcessInstanceQuery;

public class CorrelateAllMessageBatchCmd
implements Command<Batch> {
    protected String messageName;
    protected Map<String, Object> variables;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;

    public CorrelateAllMessageBatchCmd(MessageCorrelationAsyncBuilderImpl asyncBuilder) {
        this.messageName = asyncBuilder.getMessageName();
        this.variables = asyncBuilder.getPayloadProcessInstanceVariables();
        this.processInstanceIds = asyncBuilder.getProcessInstanceIds();
        this.processInstanceQuery = asyncBuilder.getProcessInstanceQuery();
        this.historicProcessInstanceQuery = asyncBuilder.getHistoricProcessInstanceQuery();
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("No process instances found.", this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery);
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        List<String> ids = elementConfiguration.getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "process instance ids", ids);
        Batch batch = new BatchBuilder(commandContext).type("correlate-message").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_CORRELATE_MESSAGE).operationLogHandler(this::writeUserOperationLog).build();
        if (this.variables != null) {
            VariableUtil.setVariablesByBatchId(this.variables, batch.getId());
        }
        return batch;
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        if (!CollectionUtil.isEmpty(this.processInstanceIds)) {
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(this.processInstanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), this.processInstanceIds);
        }
        if (this.processInstanceQuery != null) {
            elementConfiguration.addDeploymentMappings(((ProcessInstanceQueryImpl)this.processInstanceQuery).listDeploymentIdMappings());
        }
        if (this.historicProcessInstanceQuery != null) {
            elementConfiguration.addDeploymentMappings(((HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery).listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    protected BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new MessageCorrelationBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.messageName);
    }

    protected void writeUserOperationLog(CommandContext commandContext, int instancesCount) {
        ArrayList<PropertyChange> propChanges = new ArrayList<PropertyChange>();
        propChanges.add(new PropertyChange("messageName", null, this.messageName));
        propChanges.add(new PropertyChange("nrOfInstances", null, instancesCount));
        propChanges.add(new PropertyChange("nrOfVariables", null, this.variables == null ? 0 : this.variables.size()));
        propChanges.add(new PropertyChange("async", null, true));
        commandContext.getOperationLogManager().logProcessInstanceOperation("CorrelateMessage", propChanges);
    }
}

