/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.history.HistoricProcessInstanceQuery;
import org.operaton.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.batch.BatchConfiguration;
import org.operaton.bpm.engine.impl.batch.BatchElementConfiguration;
import org.operaton.bpm.engine.impl.batch.builder.BatchBuilder;
import org.operaton.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.runtime.ProcessInstanceQuery;

public class DeleteProcessInstanceBatchCmd
implements Command<Batch> {
    protected final String deleteReason;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected boolean skipCustomListeners;
    protected boolean skipSubprocesses;
    protected boolean skipIoMappings;

    public DeleteProcessInstanceBatchCmd(List<String> processInstances, ProcessInstanceQuery processInstanceQuery, HistoricProcessInstanceQuery historicProcessInstanceQuery, String deleteReason, boolean skipCustomListeners, boolean skipSubprocesses, boolean skipIoMappings) {
        this.processInstanceIds = processInstances;
        this.processInstanceQuery = processInstanceQuery;
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        this.deleteReason = deleteReason;
        this.skipCustomListeners = skipCustomListeners;
        this.skipSubprocesses = skipSubprocesses;
        this.skipIoMappings = skipIoMappings;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectProcessInstanceIds(commandContext);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", elementConfiguration.getIds());
        return new BatchBuilder(commandContext).type("instance-deletion").config(this.getConfiguration(elementConfiguration)).permission(BatchPermissions.CREATE_BATCH_DELETE_RUNNING_PROCESS_INSTANCES).operationLogHandler(this::writeUserOperationLog).build();
    }

    protected BatchElementConfiguration collectProcessInstanceIds(CommandContext commandContext) {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        List<String> processInstanceIds = this.getProcessInstanceIds();
        if (!CollectionUtil.isEmpty(processInstanceIds)) {
            ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
            query.processInstanceIds(new HashSet<String>(processInstanceIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings), processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(processInstanceQuery.listDeploymentIdMappings());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historicProcessInstanceQuery) != null) {
            elementConfiguration.addDeploymentMappings(historicProcessInstanceQuery.listDeploymentIdMappings());
        }
        return elementConfiguration;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, true));
        propertyChanges.add(new PropertyChange("deleteReason", null, this.deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", null, null, null, propertyChanges);
    }

    public BatchConfiguration getConfiguration(BatchElementConfiguration elementConfiguration) {
        return new DeleteProcessInstanceBatchConfiguration(elementConfiguration.getIds(), elementConfiguration.getMappings(), this.deleteReason, this.skipCustomListeners, this.skipSubprocesses, false, this.skipIoMappings);
    }
}

