/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd.optimize;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.operaton.bpm.engine.history.HistoricVariableUpdate;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.operaton.bpm.engine.impl.util.CollectionUtil;
import org.operaton.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.operaton.bpm.engine.variable.type.ValueType;

public class OptimizeHistoricVariableUpdateQueryCmd
implements Command<List<HistoricVariableUpdate>> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Date occurredAfter;
    protected Date occurredAt;
    protected boolean excludeObjectValues;
    protected int maxResults;

    public OptimizeHistoricVariableUpdateQueryCmd(Date occurredAfter, Date occurredAt, boolean excludeObjectValues, int maxResults) {
        this.occurredAfter = occurredAfter;
        this.occurredAt = occurredAt;
        this.excludeObjectValues = excludeObjectValues;
        this.maxResults = maxResults;
    }

    @Override
    public List<HistoricVariableUpdate> execute(CommandContext commandContext) {
        List<HistoricVariableUpdate> historicVariableUpdates = commandContext.getOptimizeManager().getHistoricVariableUpdates(this.occurredAfter, this.occurredAt, this.maxResults);
        this.fetchVariableValues(historicVariableUpdates, commandContext);
        return historicVariableUpdates;
    }

    private void fetchVariableValues(List<HistoricVariableUpdate> historicVariableUpdates, CommandContext commandContext) {
        if (!CollectionUtil.isEmpty(historicVariableUpdates)) {
            List<String> byteArrayIds = this.getByteArrayIds(historicVariableUpdates);
            if (!byteArrayIds.isEmpty()) {
                commandContext.getOptimizeManager().fetchHistoricVariableUpdateByteArrays(byteArrayIds);
            }
            this.resolveTypedValues(historicVariableUpdates);
        }
    }

    protected boolean shouldFetchValue(HistoricDetailVariableInstanceUpdateEntity entity) {
        ValueType entityType = entity.getSerializer().getType();
        return !AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(entityType.getName()) && (!ValueType.OBJECT.equals(entityType) || !this.excludeObjectValues);
    }

    protected boolean isHistoricDetailVariableInstanceUpdateEntity(HistoricVariableUpdate variableUpdate) {
        return variableUpdate instanceof HistoricDetailVariableInstanceUpdateEntity;
    }

    protected List<String> getByteArrayIds(List<HistoricVariableUpdate> variableUpdates) {
        ArrayList<String> byteArrayIds = new ArrayList<String>();
        for (HistoricVariableUpdate variableUpdate : variableUpdates) {
            String byteArrayId;
            HistoricDetailVariableInstanceUpdateEntity entity;
            if (!this.isHistoricDetailVariableInstanceUpdateEntity(variableUpdate) || !this.shouldFetchValue(entity = (HistoricDetailVariableInstanceUpdateEntity)variableUpdate) || (byteArrayId = entity.getByteArrayValueId()) == null) continue;
            byteArrayIds.add(byteArrayId);
        }
        return byteArrayIds;
    }

    protected void resolveTypedValues(List<HistoricVariableUpdate> variableUpdates) {
        for (HistoricVariableUpdate variableUpdate : variableUpdates) {
            HistoricDetailVariableInstanceUpdateEntity entity;
            if (!this.isHistoricDetailVariableInstanceUpdateEntity(variableUpdate) || !this.shouldFetchValue(entity = (HistoricDetailVariableInstanceUpdateEntity)variableUpdate)) continue;
            try {
                entity.getTypedValue(false);
            }
            catch (Exception t) {
                LOG.exceptionWhileGettingValueForVariable(t);
            }
        }
    }
}

