/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.core.operation;

import java.util.List;
import org.operaton.bpm.engine.delegate.BaseDelegateExecution;
import org.operaton.bpm.engine.delegate.DelegateListener;
import org.operaton.bpm.engine.impl.core.instance.CoreExecution;
import org.operaton.bpm.engine.impl.core.model.CoreModelElement;
import org.operaton.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.operaton.bpm.engine.impl.pvm.PvmException;

public abstract class AbstractEventAtomicOperation<T extends CoreExecution>
implements CoreAtomicOperation<T> {
    @Override
    public boolean isAsync(T execution) {
        return false;
    }

    @Override
    public void execute(T execution) {
        CoreModelElement scope = this.getScope(execution);
        List<DelegateListener<BaseDelegateExecution>> listeners = ((CoreExecution)execution).hasFailedOnEndListeners() ? this.getBuiltinListeners(scope) : this.getListeners(scope, execution);
        int listenerIndex = ((CoreExecution)execution).getListenerIndex();
        if (listenerIndex == 0) {
            execution = this.eventNotificationsStarted(execution);
        }
        if (!this.isSkipNotifyListeners(execution)) {
            if (listeners.size() > listenerIndex) {
                ((CoreExecution)execution).setEventName(this.getEventName());
                ((CoreExecution)execution).setEventSource(scope);
                DelegateListener<BaseDelegateExecution> listener = listeners.get(listenerIndex);
                ((CoreExecution)execution).setListenerIndex(listenerIndex + 1);
                try {
                    ((CoreExecution)execution).invokeListener(listener);
                }
                catch (Exception ex) {
                    this.eventNotificationsFailed(execution, ex);
                    return;
                }
                ((CoreExecution)execution).performOperationSync(this);
            } else {
                this.resetListeners(execution);
                this.eventNotificationsCompleted(execution);
            }
        } else {
            this.eventNotificationsCompleted(execution);
        }
    }

    protected void resetListeners(T execution) {
        ((CoreExecution)execution).setListenerIndex(0);
        ((CoreExecution)execution).setEventName(null);
        ((CoreExecution)execution).setEventSource(null);
    }

    protected List<DelegateListener<? extends BaseDelegateExecution>> getListeners(CoreModelElement scope, T execution) {
        if (((CoreExecution)execution).isSkipCustomListeners()) {
            return this.getBuiltinListeners(scope);
        }
        return scope.getListeners(this.getEventName());
    }

    protected List<DelegateListener<? extends BaseDelegateExecution>> getBuiltinListeners(CoreModelElement scope) {
        return scope.getBuiltInListeners(this.getEventName());
    }

    protected boolean isSkipNotifyListeners(T execution) {
        return false;
    }

    protected T eventNotificationsStarted(T execution) {
        return execution;
    }

    protected abstract CoreModelElement getScope(T var1);

    protected abstract String getEventName();

    protected abstract void eventNotificationsCompleted(T var1);

    protected void eventNotificationsFailed(T execution, Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new PvmException("couldn't execute event listener : " + exception.getMessage(), exception);
    }
}

