/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.db;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.CompositePermissionCheck;
import org.operaton.bpm.engine.impl.db.PermissionCheck;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationManager;

public class PermissionCheckBuilder {
    protected List<PermissionCheck> atomicChecks = new ArrayList<PermissionCheck>();
    protected List<CompositePermissionCheck> compositeChecks = new ArrayList<CompositePermissionCheck>();
    protected boolean disjunctive = true;
    protected PermissionCheckBuilder parent;

    public PermissionCheckBuilder() {
    }

    public PermissionCheckBuilder(PermissionCheckBuilder parent) {
        this.parent = parent;
    }

    public PermissionCheckBuilder disjunctive() {
        this.disjunctive = true;
        return this;
    }

    public PermissionCheckBuilder conjunctive() {
        this.disjunctive = false;
        return this;
    }

    public PermissionCheckBuilder atomicCheck(Resource resource, String queryParam, Permission permission) {
        if (!this.isPermissionDisabled(permission)) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            this.atomicChecks.add(permCheck);
        }
        return this;
    }

    public PermissionCheckBuilder atomicCheckForResourceId(Resource resource, String resourceId, Permission permission) {
        if (!this.isPermissionDisabled(permission)) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceId(resourceId);
            permCheck.setPermission(permission);
            this.atomicChecks.add(permCheck);
        }
        return this;
    }

    public PermissionCheckBuilder composite() {
        return new PermissionCheckBuilder(this);
    }

    public PermissionCheckBuilder done() {
        this.parent.compositeChecks.add(this.build());
        return this.parent;
    }

    public CompositePermissionCheck build() {
        this.validate();
        CompositePermissionCheck permissionCheck = new CompositePermissionCheck(this.disjunctive);
        permissionCheck.setAtomicChecks(this.atomicChecks);
        permissionCheck.setCompositeChecks(this.compositeChecks);
        return permissionCheck;
    }

    public List<PermissionCheck> getAtomicChecks() {
        return this.atomicChecks;
    }

    protected void validate() {
        if (!this.atomicChecks.isEmpty() && !this.compositeChecks.isEmpty()) {
            throw new ProcessEngineException("Mixed authorization checks of atomic and composite permissions are not supported");
        }
    }

    public boolean isPermissionDisabled(Permission permission) {
        AuthorizationManager authorizationManager = Context.getCommandContext().getAuthorizationManager();
        return authorizationManager.isPermissionDisabled(permission);
    }
}

