/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.db.entitymanager.cache;

import java.util.Collections;
import java.util.Set;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.HasDbReferences;
import org.operaton.bpm.engine.impl.db.entitymanager.Recyclable;
import org.operaton.bpm.engine.impl.db.entitymanager.cache.DbEntityState;

public class CachedDbEntity
implements Recyclable {
    protected DbEntity dbEntity;
    protected Object copy;
    protected DbEntityState entityState;
    protected Set<String> flushRelevantEntityReferences = null;

    @Override
    public void recycle() {
        this.dbEntity = null;
        this.copy = null;
        this.entityState = null;
    }

    public boolean isDirty() {
        return !this.dbEntity.getPersistentState().equals(this.copy);
    }

    public void forceSetDirty() {
        this.copy = -1;
    }

    public void makeCopy() {
        this.copy = this.dbEntity.getPersistentState();
    }

    public String toString() {
        return this.entityState + " " + this.dbEntity.getClass().getSimpleName() + "[" + this.dbEntity.getId() + "]";
    }

    public void determineEntityReferences() {
        this.flushRelevantEntityReferences = this.dbEntity instanceof HasDbReferences ? ((HasDbReferences)((Object)this.dbEntity)).getReferencedEntityIds() : Collections.emptySet();
    }

    public boolean areFlushRelevantReferencesDetermined() {
        return this.flushRelevantEntityReferences != null;
    }

    public Set<String> getFlushRelevantEntityReferences() {
        return this.flushRelevantEntityReferences;
    }

    public DbEntity getEntity() {
        return this.dbEntity;
    }

    public void setEntity(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
    }

    public DbEntityState getEntityState() {
        return this.entityState;
    }

    public void setEntityState(DbEntityState entityState) {
        this.entityState = entityState;
    }

    public Class<? extends DbEntity> getEntityType() {
        return this.dbEntity.getClass();
    }
}

