/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.digest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.digest.DatabasePrefixHandler;
import org.operaton.bpm.engine.impl.digest.PasswordEncryptor;
import org.operaton.bpm.engine.impl.digest.SecurityLogger;
import org.operaton.bpm.engine.impl.digest.Sha512HashDigest;
import org.operaton.bpm.engine.impl.digest.ShaHashDigest;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class PasswordManager {
    public static final SecurityLogger LOG = ProcessEngineLogger.SECURITY_LOGGER;
    protected Map<String, PasswordEncryptor> passwordChecker = new HashMap<String, PasswordEncryptor>();
    protected PasswordEncryptor defaultPasswordEncryptor;
    protected DatabasePrefixHandler prefixHandler = new DatabasePrefixHandler();

    public PasswordManager(PasswordEncryptor defaultPasswordEncryptor, List<PasswordEncryptor> customPasswordChecker) {
        this.addPasswordCheckerAndThrowErrorIfAlreadyAvailable(new ShaHashDigest());
        this.addPasswordCheckerAndThrowErrorIfAlreadyAvailable(new Sha512HashDigest());
        this.addAllPasswordChecker(customPasswordChecker);
        this.addDefaultEncryptor(defaultPasswordEncryptor);
    }

    protected void addAllPasswordChecker(List<PasswordEncryptor> list) {
        for (PasswordEncryptor encryptor : list) {
            this.addPasswordCheckerAndThrowErrorIfAlreadyAvailable(encryptor);
        }
    }

    protected void addPasswordCheckerAndThrowErrorIfAlreadyAvailable(PasswordEncryptor encryptor) {
        if (this.passwordChecker.containsKey(encryptor.hashAlgorithmName())) {
            throw LOG.hashAlgorithmForPasswordEncryptionAlreadyAvailableException(encryptor.hashAlgorithmName());
        }
        this.passwordChecker.put(encryptor.hashAlgorithmName(), encryptor);
    }

    protected void addDefaultEncryptor(PasswordEncryptor defaultPasswordEncryptor) {
        this.defaultPasswordEncryptor = defaultPasswordEncryptor;
        this.passwordChecker.put(defaultPasswordEncryptor.hashAlgorithmName(), defaultPasswordEncryptor);
    }

    public String encrypt(String password) {
        String prefix = this.prefixHandler.generatePrefix(this.defaultPasswordEncryptor.hashAlgorithmName());
        return prefix + this.defaultPasswordEncryptor.encrypt(password);
    }

    public boolean check(String password, String encrypted) {
        PasswordEncryptor encryptor = this.getCorrectEncryptorForPassword(encrypted);
        String encryptedPasswordWithoutPrefix = this.prefixHandler.removePrefix(encrypted);
        EnsureUtil.ensureNotNull("encryptedPasswordWithoutPrefix", (Object)encryptedPasswordWithoutPrefix);
        return encryptor.check(password, encryptedPasswordWithoutPrefix);
    }

    protected PasswordEncryptor getCorrectEncryptorForPassword(String encryptedPassword) {
        String hashAlgorithmName = this.prefixHandler.retrieveAlgorithmName(encryptedPassword);
        if (hashAlgorithmName == null || !this.passwordChecker.containsKey(hashAlgorithmName)) {
            throw LOG.cannotResolveAlgorithmPrefixFromGivenPasswordException(hashAlgorithmName, this.passwordChecker.keySet());
        }
        return this.passwordChecker.get(hashAlgorithmName);
    }
}

