/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn.configuration;

import java.util.List;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import org.operaton.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.operaton.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.operaton.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.operaton.bpm.dmn.feel.impl.scala.function.FeelCustomFunctionProvider;
import org.operaton.bpm.engine.impl.dmn.transformer.DecisionDefinitionHandler;
import org.operaton.bpm.engine.impl.dmn.transformer.DecisionRequirementsDefinitionTransformHandler;
import org.operaton.bpm.engine.impl.history.parser.HistoryDecisionEvaluationListener;
import org.operaton.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.operaton.bpm.engine.impl.metrics.dmn.MetricsDecisionEvaluationListener;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.model.dmn.instance.Decision;
import org.operaton.bpm.model.dmn.instance.Definitions;

public class DmnEngineConfigurationBuilder {
    protected final DefaultDmnEngineConfiguration dmnEngineConfiguration;
    protected DmnHistoryEventProducer dmnHistoryEventProducer;
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected ElProvider elProvider;
    protected List<FeelCustomFunctionProvider> feelCustomFunctionProviders;

    public DmnEngineConfigurationBuilder(DefaultDmnEngineConfiguration dmnEngineConfiguration) {
        EnsureUtil.ensureNotNull("dmnEngineConfiguration", (Object)dmnEngineConfiguration);
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }

    public DmnEngineConfigurationBuilder dmnHistoryEventProducer(DmnHistoryEventProducer dmnHistoryEventProducer) {
        this.dmnHistoryEventProducer = dmnHistoryEventProducer;
        return this;
    }

    public DmnEngineConfigurationBuilder scriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
        return this;
    }

    public DmnEngineConfigurationBuilder elProvider(ElProvider elProvider) {
        this.elProvider = elProvider;
        return this;
    }

    public DmnEngineConfigurationBuilder feelCustomFunctionProviders(List<FeelCustomFunctionProvider> feelCustomFunctionProviders) {
        this.feelCustomFunctionProviders = feelCustomFunctionProviders;
        return this;
    }

    public DefaultDmnEngineConfiguration build() {
        List<DmnDecisionEvaluationListener> decisionEvaluationListeners = this.createCustomPostDecisionEvaluationListeners();
        this.dmnEngineConfiguration.setCustomPostDecisionEvaluationListeners(decisionEvaluationListeners);
        DmnTransformer dmnTransformer = this.dmnEngineConfiguration.getTransformer();
        dmnTransformer.getElementTransformHandlerRegistry().addHandler(Definitions.class, (DmnElementTransformHandler)new DecisionRequirementsDefinitionTransformHandler());
        dmnTransformer.getElementTransformHandlerRegistry().addHandler(Decision.class, (DmnElementTransformHandler)new DecisionDefinitionHandler());
        if (this.dmnEngineConfiguration.getScriptEngineResolver() == null) {
            EnsureUtil.ensureNotNull("scriptEngineResolver", (Object)this.scriptEngineResolver);
            this.dmnEngineConfiguration.setScriptEngineResolver(this.scriptEngineResolver);
        }
        if (this.dmnEngineConfiguration.getElProvider() == null) {
            EnsureUtil.ensureNotNull("elProvider", (Object)this.elProvider);
            this.dmnEngineConfiguration.setElProvider(this.elProvider);
        }
        if (this.dmnEngineConfiguration.getFeelCustomFunctionProviders() == null) {
            this.dmnEngineConfiguration.setFeelCustomFunctionProviders(this.feelCustomFunctionProviders);
        }
        return this.dmnEngineConfiguration;
    }

    protected List<DmnDecisionEvaluationListener> createCustomPostDecisionEvaluationListeners() {
        EnsureUtil.ensureNotNull("dmnHistoryEventProducer", (Object)this.dmnHistoryEventProducer);
        HistoryDecisionEvaluationListener historyDecisionEvaluationListener = new HistoryDecisionEvaluationListener(this.dmnHistoryEventProducer);
        List customPostDecisionEvaluationListeners = this.dmnEngineConfiguration.getCustomPostDecisionEvaluationListeners();
        customPostDecisionEvaluationListeners.add(new MetricsDecisionEvaluationListener());
        customPostDecisionEvaluationListeners.add(historyDecisionEvaluationListener);
        return customPostDecisionEvaluationListeners;
    }

    public DmnEngineConfigurationBuilder enableFeelLegacyBehavior(boolean dmnFeelEnableLegacyBehavior) {
        this.dmnEngineConfiguration.enableFeelLegacyBehavior(dmnFeelEnableLegacyBehavior);
        return this;
    }

    public DmnEngineConfigurationBuilder returnBlankTableOutputAsNull(boolean dmnReturnBlankTableOutputAsNull) {
        this.dmnEngineConfiguration.setReturnBlankTableOutputAsNull(dmnReturnBlankTableOutputAsNull);
        return this;
    }
}

