/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn.entity.repository;

import java.util.HashMap;
import java.util.List;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.persistence.AbstractManager;
import org.operaton.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.repository.DecisionDefinition;

public class DecisionDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<DecisionDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    public void insertDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getDbEntityManager().insert(decisionDefinition);
        this.createDefaultAuthorizations(decisionDefinition);
    }

    public void deleteDecisionDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(DecisionDefinitionEntity.class, "deleteDecisionDefinitionsByDeploymentId", deploymentId);
    }

    public DecisionDefinitionEntity findDecisionDefinitionById(String decisionDefinitionId) {
        return this.getDbEntityManager().selectById(DecisionDefinitionEntity.class, decisionDefinitionId);
    }

    public DecisionDefinitionEntity findLatestDecisionDefinitionByKey(String decisionDefinitionKey) {
        List decisionDefinitions = this.getDbEntityManager().selectList("selectLatestDecisionDefinitionByKey", this.configureParameterizedQuery(decisionDefinitionKey));
        if (decisionDefinitions.isEmpty()) {
            return null;
        }
        if (decisionDefinitions.size() == 1) {
            return (DecisionDefinitionEntity)decisionDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForDecisionDefinitionKeyException(decisionDefinitionKey);
    }

    public DecisionDefinitionEntity findLatestDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestDecisionDefinitionByKeyWithoutTenantId", parameters);
        }
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestDecisionDefinitionByKeyAndTenantId", parameters);
    }

    public DecisionDefinitionEntity findDecisionDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("decisionDefinitionVersion", decisionDefinitionVersion);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByKeyAndVersion", this.configureParameterizedQuery(parameters));
    }

    public DecisionDefinitionEntity findDecisionDefinitionByKeyVersionAndTenantId(String decisionDefinitionKey, Integer decisionDefinitionVersion, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("decisionDefinitionVersion", decisionDefinitionVersion);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByKeyVersionWithoutTenantId", parameters);
        }
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByKeyVersionAndTenantId", parameters);
    }

    public DecisionDefinitionEntity findDecisionDefinitionByKeyVersionTagAndTenantId(String decisionDefinitionKey, String decisionDefinitionVersionTag, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionDefinitionVersionTag", decisionDefinitionVersionTag);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        parameters.put("tenantId", tenantId);
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(parameters);
        List decisionDefinitions = this.getDbEntityManager().selectList("selectDecisionDefinitionByKeyVersionTag", parameterObject);
        if (decisionDefinitions.size() == 1) {
            return (DecisionDefinitionEntity)decisionDefinitions.get(0);
        }
        if (decisionDefinitions.isEmpty()) {
            return null;
        }
        throw LOG.multipleDefinitionsForVersionTagException(decisionDefinitionKey, decisionDefinitionVersionTag);
    }

    public DecisionDefinitionEntity findDecisionDefinitionByDeploymentAndKey(String deploymentId, String decisionDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByDeploymentAndKey", parameters);
    }

    public List<DecisionDefinition> findDecisionDefinitionsByQueryCriteria(DecisionDefinitionQueryImpl decisionDefinitionQuery, Page page) {
        this.configureDecisionDefinitionQuery(decisionDefinitionQuery);
        return this.getDbEntityManager().selectList("selectDecisionDefinitionsByQueryCriteria", decisionDefinitionQuery, page);
    }

    public long findDecisionDefinitionCountByQueryCriteria(DecisionDefinitionQueryImpl decisionDefinitionQuery) {
        this.configureDecisionDefinitionQuery(decisionDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDecisionDefinitionCountByQueryCriteria", decisionDefinitionQuery);
    }

    public String findPreviousDecisionDefinitionId(String decisionDefinitionKey, Integer version, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", decisionDefinitionKey);
        params.put("version", version);
        params.put("tenantId", tenantId);
        return (String)this.getDbEntityManager().selectOne("selectPreviousDecisionDefinitionId", params);
    }

    public List<DecisionDefinition> findDecisionDefinitionByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectDecisionDefinitionByDeploymentId", deploymentId);
    }

    protected void createDefaultAuthorizations(DecisionDefinition decisionDefinition) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDecisionDefinition(decisionDefinition);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureDecisionDefinitionQuery(DecisionDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureDecisionDefinitionQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    @Override
    public DecisionDefinitionEntity findLatestDefinitionById(String id) {
        return this.findDecisionDefinitionById(id);
    }

    @Override
    public DecisionDefinitionEntity findLatestDefinitionByKey(String key) {
        return this.findLatestDecisionDefinitionByKey(key);
    }

    @Override
    public DecisionDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(DecisionDefinitionEntity.class, definitionId);
    }

    @Override
    public DecisionDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.findLatestDecisionDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    public DecisionDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        return this.findDecisionDefinitionByKeyVersionAndTenantId(definitionKey, definitionVersion, tenantId);
    }

    @Override
    public DecisionDefinitionEntity findDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId) {
        return this.findDecisionDefinitionByKeyVersionTagAndTenantId(definitionKey, definitionVersionTag, tenantId);
    }

    @Override
    public DecisionDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.findDecisionDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }
}

