/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.deployer;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import operatonjar.impl.com.google.gson.Gson;
import operatonjar.impl.com.google.gson.JsonObject;
import org.operaton.bpm.engine.impl.AbstractDefinitionDeployer;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.core.model.Properties;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;
import org.operaton.bpm.engine.impl.util.JsonUtil;

public class OperatonFormDefinitionDeployer
extends AbstractDefinitionDeployer<OperatonFormDefinitionEntity> {
    protected static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};

    @Override
    protected String[] getResourcesSuffixes() {
        return FORM_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<OperatonFormDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        String formContent = new String(resource.getBytes(), StandardCharsets.UTF_8);
        try {
            JsonObject formJsonObject = new Gson().fromJson(formContent, JsonObject.class);
            String operatonFormDefinitionKey = JsonUtil.getString(formJsonObject, "id");
            OperatonFormDefinitionEntity definition = new OperatonFormDefinitionEntity(operatonFormDefinitionKey, deployment.getId(), resource.getName(), deployment.getTenantId());
            return Collections.singletonList(definition);
        }
        catch (Exception e) {
            if (!this.getCommandContext().getProcessEngineConfiguration().isDisableStrictOperatonFormParsing()) {
                throw LOG.exceptionDuringFormParsing(e.getMessage(), resource.getName());
            }
            return Collections.emptyList();
        }
    }

    @Override
    protected OperatonFormDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getCommandContext().getOperatonFormDefinitionManager().findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected OperatonFormDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getCommandContext().getOperatonFormDefinitionManager().findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(OperatonFormDefinitionEntity definition) {
        this.getCommandContext().getOperatonFormDefinitionManager().insert(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, OperatonFormDefinitionEntity definition) {
        deploymentCache.addOperatonFormDefinition(definition);
    }
}

