/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.validator;

import org.operaton.bpm.engine.impl.form.validator.FormFieldConfigurationException;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidator;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidatorContext;

public abstract class AbstractNumericValidator
implements FormFieldValidator {
    @Override
    public boolean validate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        if (submittedValue == null) {
            return this.isNullValid();
        }
        String configurationString = validatorContext.getConfiguration();
        if (submittedValue instanceof Double) {
            Double configuration = null;
            try {
                configuration = Double.parseDouble(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Double value " + submittedValue + ": configuration " + configurationString + " cannot be parsed as Double.");
            }
            return this.validate((Double)submittedValue, configuration);
        }
        if (submittedValue instanceof Float) {
            Float configuration = null;
            try {
                configuration = Float.valueOf(Float.parseFloat(configurationString));
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Float value " + submittedValue + ": configuration " + configurationString + " cannot be parsed as Float.");
            }
            return this.validate((Float)submittedValue, configuration);
        }
        if (submittedValue instanceof Long) {
            Long configuration = null;
            try {
                configuration = Long.parseLong(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Long value " + submittedValue + ": configuration " + configurationString + " cannot be parsed as Long.");
            }
            return this.validate((Long)submittedValue, configuration);
        }
        if (submittedValue instanceof Integer) {
            Integer configuration = null;
            try {
                configuration = Integer.parseInt(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Integer value " + submittedValue + ": configuration " + configurationString + " cannot be parsed as Integer.");
            }
            return this.validate((Integer)submittedValue, configuration);
        }
        if (submittedValue instanceof Short) {
            Short configuration = null;
            try {
                configuration = Short.parseShort(configurationString);
            }
            catch (NumberFormatException e) {
                throw new FormFieldConfigurationException(configurationString, "Cannot validate Short value " + submittedValue + ": configuration " + configurationString + " cannot be parsed as Short.");
            }
            return this.validate((Short)submittedValue, configuration);
        }
        throw new FormFieldValidationException((Object)("Numeric validator " + this.getClass().getSimpleName() + " cannot be used on non-numeric value " + submittedValue));
    }

    protected boolean isNullValid() {
        return true;
    }

    protected abstract boolean validate(Integer var1, Integer var2);

    protected abstract boolean validate(Long var1, Long var2);

    protected abstract boolean validate(Double var1, Double var2);

    protected abstract boolean validate(Float var1, Float var2);

    protected abstract boolean validate(Short var1, Short var2);
}

