/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.validator;

import java.util.concurrent.Callable;
import org.operaton.bpm.application.InvocationContext;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.DelegateExecution;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidator;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidatorContext;
import org.operaton.bpm.engine.impl.form.validator.FormFieldValidatorInvocation;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.util.ReflectUtil;

public class DelegateFormFieldValidator
implements FormFieldValidator {
    protected String clazz;
    protected Expression delegateExpression;

    public DelegateFormFieldValidator(Expression expression) {
        this.delegateExpression = expression;
    }

    public DelegateFormFieldValidator(String clazz) {
        this.clazz = clazz;
    }

    public DelegateFormFieldValidator() {
    }

    @Override
    public boolean validate(final Object submittedValue, final FormFieldValidatorContext validatorContext) {
        DelegateExecution execution = validatorContext.getExecution();
        if (this.shouldPerformPaContextSwitch(validatorContext.getExecution())) {
            ProcessApplicationReference processApplicationReference = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
            return Context.executeWithinProcessApplication(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DelegateFormFieldValidator.this.doValidate(submittedValue, validatorContext);
                }
            }, processApplicationReference, new InvocationContext(execution));
        }
        return this.doValidate(submittedValue, validatorContext);
    }

    protected boolean shouldPerformPaContextSwitch(DelegateExecution execution) {
        if (execution == null) {
            return false;
        }
        ProcessApplicationReference targetPa = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        return targetPa != null && !targetPa.equals(Context.getCurrentProcessApplication());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doValidate(Object submittedValue, FormFieldValidatorContext validatorContext) {
        FormFieldValidator validator;
        Object validatorObject;
        if (this.clazz != null) {
            validatorObject = ReflectUtil.instantiate(this.clazz);
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator class '" + this.clazz + "' is not an instance of " + FormFieldValidator.class.getName());
            validator = (FormFieldValidator)validatorObject;
        } else {
            validatorObject = this.delegateExpression.getValue(validatorContext.getExecution());
            if (!(validatorObject instanceof FormFieldValidator)) throw new ProcessEngineException("Validator expression '" + this.delegateExpression + "' does not resolve to instance of " + FormFieldValidator.class.getName());
            validator = (FormFieldValidator)validatorObject;
        }
        FormFieldValidatorInvocation invocation = new FormFieldValidatorInvocation(validator, submittedValue, validatorContext);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
    }
}

