/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.history;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.operaton.bpm.engine.history.SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder;
import org.operaton.bpm.engine.history.SetRemovalTimeToHistoricDecisionInstancesBuilder;
import org.operaton.bpm.engine.impl.cmd.batch.removaltime.SetRemovalTimeToHistoricDecisionInstancesCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricDecisionInstancesBuilderImpl
implements SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder {
    protected HistoricDecisionInstanceQuery query;
    protected List<String> ids;
    protected Date removalTime;
    protected Mode mode = null;
    protected boolean isHierarchical;
    protected CommandExecutor commandExecutor;

    public SetRemovalTimeToHistoricDecisionInstancesBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder byQuery(HistoricDecisionInstanceQuery query) {
        this.query = query;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder byIds(String ... ids) {
        this.ids = ids != null ? Arrays.asList(ids) : null;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder absoluteRemovalTime(Date removalTime) {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.ABSOLUTE_REMOVAL_TIME;
        this.removalTime = removalTime;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder calculatedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CALCULATED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder clearedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CLEARED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricDecisionInstancesBuilder hierarchical() {
        this.isHierarchical = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new SetRemovalTimeToHistoricDecisionInstancesCmd(this));
    }

    public HistoricDecisionInstanceQuery getQuery() {
        return this.query;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Date getRemovalTime() {
        return this.removalTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isHierarchical() {
        return this.isHierarchical;
    }

    public static enum Mode {
        CALCULATED_REMOVAL_TIME,
        ABSOLUTE_REMOVAL_TIME,
        CLEARED_REMOVAL_TIME;

    }
}

