/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.history.event;

import java.util.Date;
import org.operaton.bpm.engine.history.ExternalTaskState;
import org.operaton.bpm.engine.history.HistoricExternalTaskLog;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.impl.util.ExceptionUtil;
import org.operaton.bpm.engine.impl.util.StringUtil;
import org.operaton.bpm.engine.repository.ResourceTypes;

public class HistoricExternalTaskLogEntity
extends HistoryEvent
implements HistoricExternalTaskLog {
    private static final long serialVersionUID = 1L;
    private static final String EXCEPTION_NAME = "historicExternalTaskLog.exceptionByteArray";
    protected Date timestamp;
    protected String externalTaskId;
    protected String topicName;
    protected String workerId;
    protected long priority;
    protected Integer retries;
    protected String errorMessage;
    protected String errorDetailsByteArrayId;
    protected String activityId;
    protected String activityInstanceId;
    protected String tenantId;
    protected int state;

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Override
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @Override
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage != null && errorMessage.length() > 666 ? errorMessage.substring(0, 666) : errorMessage;
    }

    public String getErrorDetailsByteArrayId() {
        return this.errorDetailsByteArrayId;
    }

    public void setErrorDetailsByteArrayId(String errorDetailsByteArrayId) {
        this.errorDetailsByteArrayId = errorDetailsByteArrayId;
    }

    public String getErrorDetails() {
        ByteArrayEntity byteArray = this.getErrorByteArray();
        return ExceptionUtil.getExceptionStacktrace(byteArray);
    }

    public void setErrorDetails(String exception) {
        EnsureUtil.ensureNotNull("exception", (Object)exception);
        byte[] exceptionBytes = StringUtil.toByteArray(exception);
        ByteArrayEntity byteArray = ExceptionUtil.createExceptionByteArray(EXCEPTION_NAME, exceptionBytes, ResourceTypes.HISTORY);
        byteArray.setRootProcessInstanceId(this.rootProcessInstanceId);
        byteArray.setRemovalTime(this.removalTime);
        this.errorDetailsByteArrayId = byteArray.getId();
    }

    protected ByteArrayEntity getErrorByteArray() {
        if (this.errorDetailsByteArrayId != null) {
            return Context.getCommandContext().getDbEntityManager().selectById(ByteArrayEntity.class, this.errorDetailsByteArrayId);
        }
        return null;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public long getPriority() {
        return this.priority;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public boolean isCreationLog() {
        return this.state == ExternalTaskState.CREATED.getStateCode();
    }

    @Override
    public boolean isFailureLog() {
        return this.state == ExternalTaskState.FAILED.getStateCode();
    }

    @Override
    public boolean isSuccessLog() {
        return this.state == ExternalTaskState.SUCCESSFUL.getStateCode();
    }

    @Override
    public boolean isDeletionLog() {
        return this.state == ExternalTaskState.DELETED.getStateCode();
    }

    @Override
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @Override
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }
}

