/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.interceptor;

import java.util.concurrent.Callable;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.application.impl.ProcessApplicationContextImpl;
import org.operaton.bpm.application.impl.ProcessApplicationIdentifier;
import org.operaton.bpm.container.RuntimeContainerDelegate;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandInterceptor;

public class ProcessApplicationContextInterceptor
extends CommandInterceptor {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public ProcessApplicationContextInterceptor(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(final Command<T> command) {
        ProcessApplicationIdentifier processApplicationIdentifier = ProcessApplicationContextImpl.get();
        if (processApplicationIdentifier != null) {
            ProcessApplicationContextImpl.clear();
            try {
                ProcessApplicationReference reference = this.getPaReference(processApplicationIdentifier);
                Object t = Context.executeWithinProcessApplication(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return ProcessApplicationContextInterceptor.this.next.execute(command);
                    }
                }, reference);
                return t;
            }
            finally {
                ProcessApplicationContextImpl.set(processApplicationIdentifier);
            }
        }
        return this.next.execute(command);
    }

    protected ProcessApplicationReference getPaReference(ProcessApplicationIdentifier processApplicationIdentifier) {
        if (processApplicationIdentifier.getReference() != null) {
            return processApplicationIdentifier.getReference();
        }
        if (processApplicationIdentifier.getProcessApplication() != null) {
            return processApplicationIdentifier.getProcessApplication().getReference();
        }
        if (processApplicationIdentifier.getName() != null) {
            RuntimeContainerDelegate runtimeContainerDelegate = RuntimeContainerDelegate.INSTANCE.get();
            ProcessApplicationReference reference = runtimeContainerDelegate.getDeployedProcessApplication(processApplicationIdentifier.getName());
            if (reference == null) {
                throw LOG.paWithNameNotRegistered(processApplicationIdentifier.getName());
            }
            return reference;
        }
        throw LOG.cannotReolvePa(processApplicationIdentifier);
    }
}

