/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor;

import org.operaton.bpm.engine.OptimisticLockingException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cmd.ExecuteJobsCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.interceptor.ProcessDataContext;
import org.operaton.bpm.engine.impl.jobexecutor.FailedJobListener;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.operaton.bpm.engine.impl.jobexecutor.JobFailureCollector;
import org.operaton.bpm.engine.impl.jobexecutor.SuccessfulJobListener;

public class ExecuteJobHelper {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    public static ExceptionLoggingHandler LOGGING_HANDLER = new ExceptionLoggingHandler(){

        @Override
        public void exceptionWhileExecutingJob(String jobId, Throwable exception) {
            LOG.exceptionWhileExecutingJob(jobId, exception);
        }
    };

    public static void executeJob(String jobId, CommandExecutor commandExecutor) {
        JobFailureCollector jobFailureCollector = new JobFailureCollector(jobId);
        ExecuteJobHelper.executeJob(jobId, commandExecutor, jobFailureCollector, new ExecuteJobsCmd(jobId, jobFailureCollector));
    }

    public static void executeJob(String nextJobId, CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector, Command<Void> cmd) {
        ExecuteJobHelper.executeJob(nextJobId, commandExecutor, jobFailureCollector, cmd, null);
    }

    public static void executeJob(String nextJobId, CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector, Command<Void> cmd, ProcessEngineConfigurationImpl configuration) {
        try {
            commandExecutor.execute(cmd);
        }
        catch (RuntimeException exception) {
            ExecuteJobHelper.handleJobFailure(nextJobId, jobFailureCollector, exception);
            throw exception;
        }
        catch (Throwable exception) {
            ExecuteJobHelper.handleJobFailure(nextJobId, jobFailureCollector, exception);
            throw LOG.wrapJobExecutionFailure(jobFailureCollector, exception);
        }
        finally {
            ProcessDataContext processDataContext = null;
            if (configuration != null) {
                processDataContext = new ProcessDataContext(configuration, true);
                processDataContext.clearMdc();
            }
            ExecuteJobHelper.invokeJobListener(commandExecutor, jobFailureCollector);
            if (processDataContext != null) {
                processDataContext.updateMdcFromCurrentValues();
            }
        }
    }

    protected static void invokeJobListener(CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector) {
        if (jobFailureCollector.getJobId() != null) {
            if (jobFailureCollector.getFailure() != null) {
                FailedJobListener failedJobListener = ExecuteJobHelper.createFailedJobListener(commandExecutor, jobFailureCollector);
                OptimisticLockingException exception = ExecuteJobHelper.callFailedJobListenerWithRetries(commandExecutor, failedJobListener);
                if (exception != null) {
                    throw exception;
                }
            } else {
                SuccessfulJobListener successListener = ExecuteJobHelper.createSuccessfulJobListener(commandExecutor);
                commandExecutor.execute(successListener);
            }
        }
    }

    private static OptimisticLockingException callFailedJobListenerWithRetries(CommandExecutor commandExecutor, FailedJobListener failedJobListener) {
        try {
            commandExecutor.execute(failedJobListener);
            return null;
        }
        catch (OptimisticLockingException ex) {
            failedJobListener.incrementCountRetries();
            if (failedJobListener.getRetriesLeft() > 0) {
                return ExecuteJobHelper.callFailedJobListenerWithRetries(commandExecutor, failedJobListener);
            }
            return ex;
        }
    }

    protected static void handleJobFailure(String nextJobId, JobFailureCollector jobFailureCollector, Throwable exception) {
        jobFailureCollector.setFailure(exception);
    }

    protected static FailedJobListener createFailedJobListener(CommandExecutor commandExecutor, JobFailureCollector jobFailureCollector) {
        return new FailedJobListener(commandExecutor, jobFailureCollector);
    }

    protected static SuccessfulJobListener createSuccessfulJobListener(CommandExecutor commandExecutor) {
        return new SuccessfulJobListener();
    }

    public static interface ExceptionLoggingHandler {
        public void exceptionWhileExecutingJob(String var1, Throwable var2);
    }
}

