/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor;

import operatonjar.impl.com.google.gson.JsonObject;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.jobexecutor.JobHandler;
import org.operaton.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.operaton.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.util.JsonUtil;

public abstract class TimerChangeJobDefinitionSuspensionStateJobHandler
implements JobHandler<JobDefinitionSuspensionStateConfiguration> {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String JOB_HANDLER_CFG_INCLUDE_JOBS = "includeJobs";

    @Override
    public void execute(JobDefinitionSuspensionStateConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetJobDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected abstract AbstractSetJobDefinitionStateCmd getCommand(JobDefinitionSuspensionStateConfiguration var1);

    @Override
    public JobDefinitionSuspensionStateConfiguration newConfiguration(String canonicalString) {
        JsonObject jsonObject = JsonUtil.asObject(canonicalString);
        return JobDefinitionSuspensionStateConfiguration.fromJson(jsonObject);
    }

    @Override
    public void onDelete(JobDefinitionSuspensionStateConfiguration configuration, JobEntity jobEntity) {
    }

    public static class JobDefinitionSuspensionStateConfiguration
    implements JobHandlerConfiguration {
        protected String jobDefinitionId;
        protected String processDefinitionKey;
        protected String processDefinitionId;
        protected boolean includeJobs;
        protected String tenantId;
        protected boolean isTenantIdSet;
        protected String by;

        @Override
        public String toCanonicalString() {
            JsonObject json = JsonUtil.createObject();
            JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY, this.by);
            JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID, this.jobDefinitionId);
            JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, this.processDefinitionKey);
            JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS, this.includeJobs);
            JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, this.processDefinitionId);
            if (this.isTenantIdSet) {
                if (this.tenantId != null) {
                    JsonUtil.addField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, this.tenantId);
                } else {
                    JsonUtil.addNullField(json, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
                }
            }
            return json.toString();
        }

        public UpdateJobDefinitionSuspensionStateBuilderImpl createBuilder() {
            UpdateJobDefinitionSuspensionStateBuilderImpl builder = new UpdateJobDefinitionSuspensionStateBuilderImpl();
            if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID.equals(this.by)) {
                builder.byProcessDefinitionId(this.processDefinitionId);
            } else if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID.equals(this.by)) {
                builder.byJobDefinitionId(this.jobDefinitionId);
            } else if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY.equals(this.by)) {
                builder.byProcessDefinitionKey(this.processDefinitionKey);
                if (this.isTenantIdSet) {
                    if (this.tenantId != null) {
                        builder.processDefinitionTenantId(this.tenantId);
                    } else {
                        builder.processDefinitionWithoutTenantId();
                    }
                }
            } else {
                throw new ProcessEngineException("Unexpected job handler configuration for property 'by': " + this.by);
            }
            builder.includeJobs(this.includeJobs);
            return builder;
        }

        public static JobDefinitionSuspensionStateConfiguration fromJson(JsonObject jsonObject) {
            JobDefinitionSuspensionStateConfiguration config = new JobDefinitionSuspensionStateConfiguration();
            config.by = JsonUtil.getString(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY);
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID)) {
                config.jobDefinitionId = JsonUtil.getString(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
                config.processDefinitionId = JsonUtil.getString(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
                config.processDefinitionKey = JsonUtil.getString(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                config.isTenantIdSet = true;
                if (!JsonUtil.isNull(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                    config.tenantId = JsonUtil.getString(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
                }
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS)) {
                config.includeJobs = JsonUtil.getBoolean(jsonObject, TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS);
            }
            return config;
        }

        public static JobDefinitionSuspensionStateConfiguration byJobDefinitionId(String jobDefinitionId, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID;
            configuration.jobDefinitionId = jobDefinitionId;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration byProcessDefinitionId(String processDefinitionId, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID;
            configuration.processDefinitionId = processDefinitionId;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration byProcessDefinitionKey(String processDefinitionKey, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY;
            configuration.processDefinitionKey = processDefinitionKey;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration ByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, boolean includeProcessInstances) {
            JobDefinitionSuspensionStateConfiguration configuration = JobDefinitionSuspensionStateConfiguration.byProcessDefinitionKey(processDefinitionKey, includeProcessInstances);
            configuration.isTenantIdSet = true;
            configuration.tenantId = tenantId;
            return configuration;
        }
    }
}

