/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Calendar;
import java.util.Date;
import operatonjar.impl.com.google.gson.JsonObject;
import org.operaton.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.operaton.bpm.engine.impl.util.JsonUtil;

public class HistoryCleanupJobHandlerConfiguration
implements JobHandlerConfiguration {
    public static final int START_DELAY = 10;
    public static final int MAX_DELAY = 3600;
    public static final String JOB_CONFIG_COUNT_EMPTY_RUNS = "countEmptyRuns";
    public static final String JOB_CONFIG_EXECUTE_AT_ONCE = "immediatelyDue";
    public static final String JOB_CONFIG_MINUTE_FROM = "minuteFrom";
    public static final String JOB_CONFIG_MINUTE_TO = "minuteTo";
    private int countEmptyRuns = 0;
    private boolean immediatelyDue;
    private int minuteFrom = 0;
    private int minuteTo = 59;

    @Override
    public String toCanonicalString() {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, JOB_CONFIG_COUNT_EMPTY_RUNS, this.countEmptyRuns);
        JsonUtil.addField(json, JOB_CONFIG_EXECUTE_AT_ONCE, this.immediatelyDue);
        JsonUtil.addField(json, JOB_CONFIG_MINUTE_FROM, this.minuteFrom);
        JsonUtil.addField(json, JOB_CONFIG_MINUTE_TO, this.minuteTo);
        return json.toString();
    }

    public static HistoryCleanupJobHandlerConfiguration fromJson(JsonObject jsonObject) {
        HistoryCleanupJobHandlerConfiguration config = new HistoryCleanupJobHandlerConfiguration();
        if (jsonObject.has(JOB_CONFIG_COUNT_EMPTY_RUNS)) {
            config.setCountEmptyRuns(JsonUtil.getInt(jsonObject, JOB_CONFIG_COUNT_EMPTY_RUNS));
        }
        if (jsonObject.has(JOB_CONFIG_EXECUTE_AT_ONCE)) {
            config.setImmediatelyDue(JsonUtil.getBoolean(jsonObject, JOB_CONFIG_EXECUTE_AT_ONCE));
        }
        config.setMinuteFrom(JsonUtil.getInt(jsonObject, JOB_CONFIG_MINUTE_FROM));
        config.setMinuteTo(JsonUtil.getInt(jsonObject, JOB_CONFIG_MINUTE_TO));
        return config;
    }

    public Date getNextRunWithDelay(Date date) {
        Date result = this.addSeconds(date, Math.min((int)(Math.pow(2.0, this.countEmptyRuns) * 10.0), 3600));
        return result;
    }

    private Date addSeconds(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, amount);
        return c.getTime();
    }

    public int getCountEmptyRuns() {
        return this.countEmptyRuns;
    }

    public void setCountEmptyRuns(int countEmptyRuns) {
        this.countEmptyRuns = countEmptyRuns;
    }

    public boolean isImmediatelyDue() {
        return this.immediatelyDue;
    }

    public void setImmediatelyDue(boolean immediatelyDue) {
        this.immediatelyDue = immediatelyDue;
    }

    public int getMinuteFrom() {
        return this.minuteFrom;
    }

    public void setMinuteFrom(int minuteFrom) {
        this.minuteFrom = minuteFrom;
    }

    public int getMinuteTo() {
        return this.minuteTo;
    }

    public void setMinuteTo(int minuteTo) {
        this.minuteTo = minuteTo;
    }
}

