/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.SetExecutionVariablesCmd;
import org.operaton.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.migration.AbstractMigrationCmd;
import org.operaton.bpm.engine.impl.migration.MigrationLogger;
import org.operaton.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.operaton.bpm.engine.impl.migration.instance.DeleteUnmappedInstanceVisitor;
import org.operaton.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingActivityInstanceVisitor;
import org.operaton.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingProcessElementInstanceTopDownWalker;
import org.operaton.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingScopeInstanceBottomUpWalker;
import org.operaton.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigrationCompensationInstanceVisitor;
import org.operaton.bpm.engine.impl.migration.instance.parser.MigratingInstanceParser;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingCompensationInstanceValidator;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.migration.MigrationPlan;
import org.operaton.bpm.engine.variable.VariableMap;

public class MigrateProcessInstanceCmd
extends AbstractMigrationCmd
implements Command<Void> {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected boolean skipJavaSerializationFormatCheck;

    public MigrateProcessInstanceCmd(MigrationPlanExecutionBuilderImpl migrationPlanExecutionBuilder, boolean skipJavaSerializationFormatCheck) {
        super(migrationPlanExecutionBuilder);
        this.skipJavaSerializationFormatCheck = skipJavaSerializationFormatCheck;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        MigrationPlan migrationPlan = this.executionBuilder.getMigrationPlan();
        Collection<String> processInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Migration plan cannot be null", "migration plan", (Object)migrationPlan);
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot empty", "process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "process instance ids", processInstanceIds);
        ProcessDefinitionEntity sourceDefinition = this.resolveSourceProcessDefinition(commandContext);
        ProcessDefinitionEntity targetDefinition = this.resolveTargetProcessDefinition(commandContext);
        this.checkAuthorizations(commandContext, sourceDefinition, targetDefinition);
        this.writeUserOperationLog(commandContext, sourceDefinition, targetDefinition, processInstanceIds.size(), (Map<String, Object>)migrationPlan.getVariables(), false);
        commandContext.runWithoutAuthorization(() -> {
            for (String processInstanceId : processInstanceIds) {
                this.migrateProcessInstance(commandContext, processInstanceId, migrationPlan, targetDefinition, this.skipJavaSerializationFormatCheck);
            }
            return null;
        });
        return null;
    }

    public Void migrateProcessInstance(CommandContext commandContext, String processInstanceId, MigrationPlan migrationPlan, ProcessDefinitionEntity targetProcessDefinition, boolean skipJavaSerializationFormatCheck) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Process instance id cannot be null", "process instance id", (Object)processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        this.ensureProcessInstanceExist(processInstanceId, processInstance);
        this.ensureOperationAllowed(commandContext, processInstance, targetProcessDefinition);
        this.ensureSameProcessDefinition(processInstance, migrationPlan.getSourceProcessDefinitionId());
        MigratingProcessInstanceValidationReportImpl processInstanceReport = new MigratingProcessInstanceValidationReportImpl();
        ProcessEngineImpl processEngine = commandContext.getProcessEngineConfiguration().getProcessEngine();
        MigratingInstanceParser migratingInstanceParser = new MigratingInstanceParser(processEngine);
        MigratingProcessInstance migratingProcessInstance = migratingInstanceParser.parse(processInstanceId, migrationPlan, processInstanceReport);
        this.validateInstructions(commandContext, migratingProcessInstance, processInstanceReport);
        if (processInstanceReport.hasFailures()) {
            throw LOGGER.failingMigratingProcessInstanceValidation(processInstanceReport);
        }
        this.executeInContext(() -> this.deleteUnmappedActivityInstances(migratingProcessInstance), migratingProcessInstance.getSourceDefinition());
        this.executeInContext(() -> this.migrateProcessInstance(migratingProcessInstance), migratingProcessInstance.getTargetDefinition());
        VariableMap variables = migrationPlan.getVariables();
        if (variables != null) {
            commandContext.executeWithOperationLogPrevented(new SetExecutionVariablesCmd(processInstanceId, (Map<String, ?>)variables, false, skipJavaSerializationFormatCheck));
        }
        return null;
    }

    protected <T> void executeInContext(Runnable runnable, ProcessDefinitionEntity contextDefinition) {
        ProcessApplicationContextUtil.doContextSwitch(runnable, contextDefinition);
    }

    protected void deleteUnmappedActivityInstances(MigratingProcessInstance migratingProcessInstance) {
        boolean isSkipCustomListeners = this.executionBuilder.isSkipCustomListeners();
        boolean isSkipIoMappings = this.executionBuilder.isSkipIoMappings();
        DeleteUnmappedInstanceVisitor visitor = new DeleteUnmappedInstanceVisitor(isSkipCustomListeners, isSkipIoMappings);
        Set<MigratingScopeInstance> leafInstances = this.collectLeafInstances(migratingProcessInstance);
        for (MigratingScopeInstance leafInstance : leafInstances) {
            MigratingScopeInstanceBottomUpWalker walker = new MigratingScopeInstanceBottomUpWalker(leafInstance);
            walker.addPreVisitor(visitor);
            walker.walkUntil(element -> element == null || !visitor.hasVisitedAll(element.getChildScopeInstances()));
        }
    }

    protected Set<MigratingScopeInstance> collectLeafInstances(MigratingProcessInstance migratingProcessInstance) {
        HashSet<MigratingScopeInstance> leafInstances = new HashSet<MigratingScopeInstance>();
        Collection<MigratingScopeInstance> migratingScopeInstances = migratingProcessInstance.getMigratingScopeInstances();
        for (MigratingScopeInstance migratingScopeInstance : migratingScopeInstances) {
            if (!migratingScopeInstance.getChildScopeInstances().isEmpty()) continue;
            leafInstances.add(migratingScopeInstance);
        }
        return leafInstances;
    }

    protected void validateInstructions(CommandContext commandContext, MigratingProcessInstance migratingProcessInstance, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        MigratingActivityInstance ancestorInstance;
        List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingActivityInstanceValidators();
        List<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingTransitionInstanceValidators();
        List<MigratingCompensationInstanceValidator> migratingCompensationInstanceValidators = commandContext.getProcessEngineConfiguration().getMigratingCompensationInstanceValidators();
        HashMap<MigratingActivityInstance, MigratingActivityInstanceValidationReportImpl> instanceReports = new HashMap<MigratingActivityInstance, MigratingActivityInstanceValidationReportImpl>();
        Collection<MigratingActivityInstance> migratingActivityInstances = migratingProcessInstance.getMigratingActivityInstances();
        for (MigratingActivityInstance migratingActivityInstance : migratingActivityInstances) {
            MigratingActivityInstanceValidationReportImpl instanceReport = this.validateActivityInstance(migratingActivityInstance, migratingProcessInstance, migratingActivityInstanceValidators);
            instanceReports.put(migratingActivityInstance, instanceReport);
        }
        Collection<MigratingEventScopeInstance> migratingEventScopeInstances = migratingProcessInstance.getMigratingEventScopeInstances();
        for (MigratingEventScopeInstance migratingEventScopeInstance : migratingEventScopeInstances) {
            ancestorInstance = migratingEventScopeInstance.getClosestAncestorActivityInstance();
            this.validateEventScopeInstance(migratingEventScopeInstance, migratingProcessInstance, migratingCompensationInstanceValidators, (MigratingActivityInstanceValidationReportImpl)instanceReports.get(ancestorInstance));
        }
        for (MigratingCompensationEventSubscriptionInstance migratingEventSubscriptionInstance : migratingProcessInstance.getMigratingCompensationSubscriptionInstances()) {
            ancestorInstance = migratingEventSubscriptionInstance.getClosestAncestorActivityInstance();
            this.validateCompensateSubscriptionInstance(migratingEventSubscriptionInstance, migratingProcessInstance, migratingCompensationInstanceValidators, (MigratingActivityInstanceValidationReportImpl)instanceReports.get(ancestorInstance));
        }
        for (MigratingActivityInstanceValidationReportImpl instanceReport : instanceReports.values()) {
            if (!instanceReport.hasFailures()) continue;
            processInstanceReport.addActivityInstanceReport(instanceReport);
        }
        Collection<MigratingTransitionInstance> collection = migratingProcessInstance.getMigratingTransitionInstances();
        for (MigratingTransitionInstance migratingTransitionInstance : collection) {
            MigratingTransitionInstanceValidationReportImpl instanceReport = this.validateTransitionInstance(migratingTransitionInstance, migratingProcessInstance, migratingTransitionInstanceValidators);
            if (!instanceReport.hasFailures()) continue;
            processInstanceReport.addTransitionInstanceReport(instanceReport);
        }
    }

    protected MigratingActivityInstanceValidationReportImpl validateActivityInstance(MigratingActivityInstance migratingActivityInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingActivityInstanceValidator> migratingActivityInstanceValidators) {
        MigratingActivityInstanceValidationReportImpl instanceReport = new MigratingActivityInstanceValidationReportImpl(migratingActivityInstance);
        for (MigratingActivityInstanceValidator migratingActivityInstanceValidator : migratingActivityInstanceValidators) {
            migratingActivityInstanceValidator.validate(migratingActivityInstance, migratingProcessInstance, instanceReport);
        }
        return instanceReport;
    }

    protected MigratingTransitionInstanceValidationReportImpl validateTransitionInstance(MigratingTransitionInstance migratingTransitionInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingTransitionInstanceValidator> migratingTransitionInstanceValidators) {
        MigratingTransitionInstanceValidationReportImpl instanceReport = new MigratingTransitionInstanceValidationReportImpl(migratingTransitionInstance);
        for (MigratingTransitionInstanceValidator migratingTransitionInstanceValidator : migratingTransitionInstanceValidators) {
            migratingTransitionInstanceValidator.validate(migratingTransitionInstance, migratingProcessInstance, instanceReport);
        }
        return instanceReport;
    }

    protected void validateEventScopeInstance(MigratingEventScopeInstance eventScopeInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingCompensationInstanceValidator> migratingTransitionInstanceValidators, MigratingActivityInstanceValidationReportImpl instanceReport) {
        for (MigratingCompensationInstanceValidator validator : migratingTransitionInstanceValidators) {
            validator.validate(eventScopeInstance, migratingProcessInstance, instanceReport);
        }
    }

    protected void validateCompensateSubscriptionInstance(MigratingCompensationEventSubscriptionInstance eventSubscriptionInstance, MigratingProcessInstance migratingProcessInstance, List<MigratingCompensationInstanceValidator> migratingTransitionInstanceValidators, MigratingActivityInstanceValidationReportImpl instanceReport) {
        for (MigratingCompensationInstanceValidator validator : migratingTransitionInstanceValidators) {
            validator.validate(eventSubscriptionInstance, migratingProcessInstance, instanceReport);
        }
    }

    protected void migrateProcessInstance(MigratingProcessInstance migratingProcessInstance) {
        MigratingActivityInstance rootActivityInstance = migratingProcessInstance.getRootInstance();
        MigratingProcessElementInstanceTopDownWalker walker = new MigratingProcessElementInstanceTopDownWalker(rootActivityInstance);
        walker.addPreVisitor(new MigratingActivityInstanceVisitor(this.executionBuilder.isSkipCustomListeners(), this.executionBuilder.isSkipIoMappings()));
        walker.addPreVisitor(new MigrationCompensationInstanceVisitor());
        walker.walkUntil();
    }

    protected void ensureProcessInstanceExist(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOGGER.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected void ensureSameProcessDefinition(ExecutionEntity processInstance, String processDefinitionId) {
        if (!processDefinitionId.equals(processInstance.getProcessDefinitionId())) {
            throw LOGGER.processDefinitionOfInstanceDoesNotMatchMigrationPlan(processInstance, processDefinitionId);
        }
    }

    protected void ensureOperationAllowed(CommandContext commandContext, ExecutionEntity processInstance, ProcessDefinitionEntity targetProcessDefinition) {
        List<CommandChecker> commandCheckers = commandContext.getProcessEngineConfiguration().getCommandCheckers();
        for (CommandChecker checker : commandCheckers) {
            checker.checkMigrateProcessInstance(processInstance, targetProcessDefinition);
        }
    }
}

