/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.instance.parser;

import java.util.List;
import org.operaton.bpm.engine.impl.migration.instance.MigratingAsyncJobInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.operaton.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import org.operaton.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.operaton.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;

public class TransitionInstanceJobHandler
implements MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, MigratingTransitionInstance transitionInstance, List<JobEntity> elements) {
        for (JobEntity job : elements) {
            if (!TransitionInstanceJobHandler.isAsyncContinuation(job)) continue;
            ScopeImpl targetScope = transitionInstance.getTargetScope();
            if (targetScope != null) {
                JobDefinitionEntity targetJobDefinitionEntity = parseContext.getTargetJobDefinition(transitionInstance.getTargetScope().getId(), job.getJobHandlerType());
                MigratingAsyncJobInstance migratingJobInstance = new MigratingAsyncJobInstance(job, targetJobDefinitionEntity, transitionInstance.getTargetScope());
                transitionInstance.setDependentJobInstance(migratingJobInstance);
                parseContext.submit(migratingJobInstance);
            }
            parseContext.consume(job);
        }
    }

    protected static boolean isAsyncContinuation(JobEntity job) {
        return job != null && "async-continuation".equals(job.getJobHandlerType());
    }
}

