/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.operaton.bpm.engine.AuthorizationException;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.operaton.bpm.engine.authorization.HistoricTaskPermissions;
import org.operaton.bpm.engine.authorization.MissingAuthorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.authorization.TaskPermissions;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.operaton.bpm.engine.impl.AuthorizationQueryImpl;
import org.operaton.bpm.engine.impl.DeploymentQueryImpl;
import org.operaton.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.operaton.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.operaton.bpm.engine.impl.ExternalTaskQueryImpl;
import org.operaton.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.operaton.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.operaton.bpm.engine.impl.HistoricDetailQueryImpl;
import org.operaton.bpm.engine.impl.HistoricExternalTaskLogQueryImpl;
import org.operaton.bpm.engine.impl.HistoricIdentityLinkLogQueryImpl;
import org.operaton.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.operaton.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.operaton.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.operaton.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.operaton.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.operaton.bpm.engine.impl.IncidentQueryImpl;
import org.operaton.bpm.engine.impl.JobDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.JobQueryImpl;
import org.operaton.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.TaskQueryImpl;
import org.operaton.bpm.engine.impl.UserOperationLogQueryImpl;
import org.operaton.bpm.engine.impl.VariableInstanceQueryImpl;
import org.operaton.bpm.engine.impl.batch.BatchQueryImpl;
import org.operaton.bpm.engine.impl.batch.BatchStatisticsQueryImpl;
import org.operaton.bpm.engine.impl.batch.history.HistoricBatchQueryImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.AuthorizationCheck;
import org.operaton.bpm.engine.impl.db.CompositePermissionCheck;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.db.PermissionCheck;
import org.operaton.bpm.engine.impl.db.PermissionCheckBuilder;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.operaton.bpm.engine.impl.identity.Authentication;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.AbstractManager;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.impl.persistence.entity.util.AuthManagerUtil;
import org.operaton.bpm.engine.impl.util.ResourceTypeUtil;

public class AuthorizationManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final List<String> EMPTY_LIST = new ArrayList<String>();
    protected Set<String> availableAuthorizedGroupIds = null;
    protected Boolean isRevokeAuthCheckUsed = null;

    public PermissionCheckBuilder newPermissionCheckBuilder() {
        return new PermissionCheckBuilder();
    }

    public Authorization createNewAuthorization(int type) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        return new AuthorizationEntity(type);
    }

    @Override
    public void insert(DbEntity authorization) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        this.getDbEntityManager().insert(authorization);
    }

    public List<Authorization> selectAuthorizationByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return this.getDbEntityManager().selectList("selectAuthorizationByQueryCriteria", authorizationQuery);
    }

    public Long selectAuthorizationCountByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return (Long)this.getDbEntityManager().selectOne("selectAuthorizationCountByQueryCriteria", authorizationQuery);
    }

    public AuthorizationEntity findAuthorizationByUserIdAndResourceId(int type, String userId, Resource resource, String resourceId) {
        return this.findAuthorization(type, userId, null, resource, resourceId);
    }

    public AuthorizationEntity findAuthorizationByGroupIdAndResourceId(int type, String groupId, Resource resource, String resourceId) {
        return this.findAuthorization(type, null, groupId, resource, resourceId);
    }

    public AuthorizationEntity findAuthorization(int type, String userId, String groupId, Resource resource, String resourceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("userId", userId);
        params.put("groupId", groupId);
        params.put("resourceId", resourceId);
        if (resource != null) {
            params.put("resourceType", resource.resourceType());
        }
        return (AuthorizationEntity)this.getDbEntityManager().selectOne("selectAuthorizationByParameters", params);
    }

    public void update(AuthorizationEntity authorization) {
        this.checkAuthorization(Permissions.UPDATE, Resources.AUTHORIZATION, authorization.getId());
        this.getDbEntityManager().merge(authorization);
    }

    @Override
    public void delete(DbEntity authorization) {
        this.checkAuthorization(Permissions.DELETE, Resources.AUTHORIZATION, authorization.getId());
        this.deleteAuthorizationsByResourceId(Resources.AUTHORIZATION, authorization.getId());
        super.delete(authorization);
    }

    public void checkAuthorization(CompositePermissionCheck compositePermissionCheck) {
        if (this.isAuthCheckExecuted()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            String userId = currentAuthentication.getUserId();
            boolean isAuthorized = this.isAuthorized(compositePermissionCheck);
            if (!isAuthorized) {
                ArrayList<MissingAuthorization> missingAuthorizations = new ArrayList<MissingAuthorization>();
                for (PermissionCheck check : compositePermissionCheck.getAllPermissionChecks()) {
                    missingAuthorizations.add(new MissingAuthorization(check.getPermission().getName(), check.getResource().resourceName(), check.getResourceId()));
                }
                throw new AuthorizationException(userId, missingAuthorizations);
            }
        }
    }

    public void checkAuthorization(Permission permission, Resource resource) {
        this.checkAuthorization(permission, resource, null);
    }

    @Override
    public void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication;
        boolean isAuthorized;
        if (this.isAuthCheckExecuted() && !(isAuthorized = this.isAuthorized((currentAuthentication = this.getCurrentAuthentication()).getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId))) {
            throw new AuthorizationException(currentAuthentication.getUserId(), permission.getName(), resource.resourceName(), resourceId);
        }
    }

    public boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && currentAuthentication.getUserId() != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId);
        }
        return true;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        if (!this.isPermissionDisabled(permission)) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setPermission(permission);
            permCheck.setResource(resource);
            permCheck.setResourceId(resourceId);
            return this.isAuthorized(userId, groupIds, permCheck);
        }
        return true;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, PermissionCheck permissionCheck) {
        if (!this.isAuthorizationEnabled()) {
            return true;
        }
        if (!this.isResourceValidForPermission(permissionCheck)) {
            throw LOG.invalidResourceForPermission(permissionCheck.getResource().resourceName(), permissionCheck.getPermission().getName());
        }
        List<String> filteredGroupIds = this.filterAuthenticatedGroupIds(groupIds);
        boolean isRevokeAuthorizationCheckEnabled = this.isRevokeAuthCheckEnabled(userId, groupIds);
        CompositePermissionCheck compositePermissionCheck = this.createCompositePermissionCheck(permissionCheck);
        AuthorizationCheck authCheck = new AuthorizationCheck(userId, filteredGroupIds, compositePermissionCheck, isRevokeAuthorizationCheckEnabled);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    protected boolean isRevokeAuthCheckEnabled(String userId, List<String> groupIds) {
        Boolean isRevokeAuthCheckEnabled = this.isRevokeAuthCheckUsed;
        if (isRevokeAuthCheckEnabled == null) {
            String configuredMode = Context.getProcessEngineConfiguration().getAuthorizationCheckRevokes();
            if (configuredMode != null) {
                configuredMode = configuredMode.toLowerCase();
            }
            if ("always".equals(configuredMode)) {
                isRevokeAuthCheckEnabled = true;
            } else if ("never".equals(configuredMode)) {
                isRevokeAuthCheckEnabled = false;
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("userId", userId);
                params.put("authGroupIds", this.filterAuthenticatedGroupIds(groupIds));
                isRevokeAuthCheckEnabled = this.getDbEntityManager().selectBoolean("selectRevokeAuthorization", params);
            }
            this.isRevokeAuthCheckUsed = isRevokeAuthCheckEnabled;
        }
        return isRevokeAuthCheckEnabled;
    }

    protected CompositePermissionCheck createCompositePermissionCheck(PermissionCheck permissionCheck) {
        CompositePermissionCheck compositePermissionCheck = new CompositePermissionCheck();
        compositePermissionCheck.setAtomicChecks(Arrays.asList(permissionCheck));
        return compositePermissionCheck;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, CompositePermissionCheck compositePermissionCheck) {
        for (PermissionCheck permissionCheck : compositePermissionCheck.getAllPermissionChecks()) {
            if (this.isResourceValidForPermission(permissionCheck)) continue;
            throw LOG.invalidResourceForPermission(permissionCheck.getResource().resourceName(), permissionCheck.getPermission().getName());
        }
        List<String> filteredGroupIds = this.filterAuthenticatedGroupIds(groupIds);
        boolean isRevokeAuthorizationCheckEnabled = this.isRevokeAuthCheckEnabled(userId, groupIds);
        AuthorizationCheck authCheck = new AuthorizationCheck(userId, filteredGroupIds, compositePermissionCheck, isRevokeAuthorizationCheckEnabled);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    public boolean isAuthorized(CompositePermissionCheck compositePermissionCheck) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (currentAuthentication != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), compositePermissionCheck);
        }
        return true;
    }

    protected boolean isResourceValidForPermission(PermissionCheck permissionCheck) {
        Resource[] permissionResources = permissionCheck.getPermission().getTypes();
        Resource givenResource = permissionCheck.getResource();
        return ResourceTypeUtil.resourceIsContainedInArray(givenResource.resourceType(), permissionResources);
    }

    public void validateResourceCompatibility(AuthorizationEntity authorization) {
        int resourceType = authorization.getResourceType();
        Set<Permission> permissionSet = authorization.getCachedPermissions();
        for (Permission permission : permissionSet) {
            if (ResourceTypeUtil.resourceIsContainedInArray(resourceType, permission.getTypes())) continue;
            throw LOG.invalidResourceForAuthorization(resourceType, permission.getName());
        }
    }

    public void configureQuery(ListQueryParameterObject query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        authCheck.getPermissionChecks().clear();
        if (this.isAuthCheckExecuted()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            authCheck.setAuthUserId(currentAuthentication.getUserId());
            authCheck.setAuthGroupIds(currentAuthentication.getGroupIds());
            this.enableQueryAuthCheck(authCheck);
        } else {
            authCheck.setAuthorizationCheckEnabled(false);
            authCheck.setAuthUserId(null);
            authCheck.setAuthGroupIds(null);
        }
    }

    public void configureQueryHistoricFinishedInstanceReport(ListQueryParameterObject query, Resource resource) {
        this.configureQuery(query);
        CompositePermissionCheck compositePermissionCheck = new PermissionCheckBuilder().conjunctive().atomicCheck(resource, "RES.KEY_", Permissions.READ).atomicCheck(resource, "RES.KEY_", Permissions.READ_HISTORY).build();
        query.getAuthCheck().setPermissionChecks(compositePermissionCheck);
    }

    public void enableQueryAuthCheck(AuthorizationCheck authCheck) {
        List<String> authGroupIds = authCheck.getAuthGroupIds();
        String authUserId = authCheck.getAuthUserId();
        authCheck.setAuthorizationCheckEnabled(true);
        authCheck.setAuthGroupIds(this.filterAuthenticatedGroupIds(authGroupIds));
        authCheck.setRevokeAuthorizationCheckEnabled(this.isRevokeAuthCheckEnabled(authUserId, authGroupIds));
    }

    public void configureQuery(AbstractQuery query, Resource resource) {
        this.configureQuery(query, resource, "RES.ID_");
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam) {
        this.configureQuery(query, resource, queryParam, Permissions.READ);
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam, Permission permission) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().atomicCheck(resource, queryParam, permission).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public boolean isPermissionDisabled(Permission permission) {
        List<String> disabledPermissions = this.getCommandContext().getProcessEngineConfiguration().getDisabledPermissions();
        if (disabledPermissions != null) {
            for (String disabledPermission : disabledPermissions) {
                if (!permission.getName().equals(disabledPermission)) continue;
                return true;
            }
        }
        return false;
    }

    protected void addPermissionCheck(AuthorizationCheck authCheck, CompositePermissionCheck compositeCheck) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            authCheck.setPermissionChecks(compositeCheck);
        }
    }

    public void deleteAuthorizationsByResourceIds(Resources resource, List<String> resourceIds) {
        if (resourceIds == null) {
            throw new IllegalArgumentException("Resource ids cannot be null");
        }
        resourceIds.forEach(resourceId -> this.deleteAuthorizationsByResourceId(resource, (String)resourceId));
    }

    public void deleteAuthorizationsByResourceId(Resource resource, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void deleteAuthorizationsByResourceIdAndUserId(Resource resource, String resourceId, String userId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            deleteParams.put("userId", userId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceIdAndUserId", deleteParams);
        }
    }

    public void deleteAuthorizationsByResourceIdAndGroupId(Resource resource, String resourceId, String groupId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            deleteParams.put("groupId", groupId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceIdAndGroupId", deleteParams);
        }
    }

    public void checkOperatonAdmin() {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && this.getCommandContext().isAuthorizationCheckEnabled() && currentAuthentication != null && !this.isOperatonAdmin(currentAuthentication)) {
            throw LOG.requiredOperatonAdmin();
        }
    }

    public void checkOperatonAdminOrPermission(Consumer<CommandChecker> permissionCheck) {
        if (this.isAuthorizationEnabled() && this.getCommandContext().isAuthorizationCheckEnabled()) {
            AuthorizationException authorizationException = null;
            AuthorizationException adminException = null;
            try {
                for (CommandChecker checker : this.getCommandContext().getProcessEngineConfiguration().getCommandCheckers()) {
                    permissionCheck.accept(checker);
                }
            }
            catch (AuthorizationException e) {
                authorizationException = e;
            }
            try {
                this.checkOperatonAdmin();
            }
            catch (AuthorizationException e) {
                adminException = e;
            }
            if (authorizationException != null && adminException != null) {
                List<MissingAuthorization> info = authorizationException.getMissingAuthorizations();
                throw LOG.requiredOperatonAdminOrPermissionException(info);
            }
        }
    }

    public boolean isOperatonAdmin(Authentication authentication) {
        String userId;
        List<String> groupIds = authentication.getGroupIds();
        if (groupIds != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<String> adminGroups = commandContext.getProcessEngineConfiguration().getAdminGroups();
            for (String adminGroup : adminGroups) {
                if (!groupIds.contains(adminGroup)) continue;
                return true;
            }
        }
        if ((userId = authentication.getUserId()) != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<String> adminUsers = commandContext.getProcessEngineConfiguration().getAdminUsers();
            return adminUsers != null && adminUsers.contains(userId);
        }
        return false;
    }

    public void configureDeploymentQuery(DeploymentQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.DEPLOYMENT);
    }

    public void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
        if (query.isStartablePermissionCheck()) {
            AuthorizationCheck authorizationCheck = query.getAuthCheck();
            if (!authorizationCheck.isRevokeAuthorizationCheckEnabled()) {
                CompositePermissionCheck permCheck = new PermissionCheckBuilder().atomicCheck(Resources.PROCESS_DEFINITION, "RES.KEY_", Permissions.CREATE_INSTANCE).build();
                query.addProcessDefinitionCreatePermissionCheck(permCheck);
            } else {
                CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().conjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.KEY_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.KEY_", Permissions.CREATE_INSTANCE).build();
                this.addPermissionCheck(authorizationCheck, permissionCheck);
            }
        }
    }

    public void configureExecutionQuery(AbstractQuery query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ_INSTANCE).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public void configureTaskQuery(TaskQueryImpl query) {
        this.configureQuery(query);
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.TASK, "RES.ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "D.KEY_", Permissions.READ_TASK).build();
            this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
        }
    }

    public void configureEventSubscriptionQuery(EventSubscriptionQueryImpl query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public void configureConditionalEventSubscriptionQuery(ListQueryParameterObject query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().atomicCheck(Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public void configureIncidentQuery(IncidentQueryImpl query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    protected void configureVariableInstanceQuery(VariableInstanceQueryImpl query) {
        this.configureQuery(query);
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck permissionCheck = this.isEnsureSpecificVariablePermission() ? new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE).atomicCheck(Resources.TASK, "RES.TASK_ID_", TaskPermissions.READ_VARIABLE).build() : new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).atomicCheck(Resources.TASK, "RES.TASK_ID_", Permissions.READ).build();
            this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
        }
    }

    public void configureJobDefinitionQuery(JobDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_");
    }

    public void configureJobQuery(JobQueryImpl query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROCESS_INSTANCE_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_INSTANCE).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public void configureHistoricProcessInstanceQuery(HistoricProcessInstanceQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "SELF.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "SELF.ID_", HistoricProcessInstancePermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricActivityInstanceQuery(HistoricActivityInstanceQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricTaskInstanceQuery(HistoricTaskInstanceQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).atomicCheck(Resources.HISTORIC_TASK, "RES.ID_", HistoricTaskPermissions.READ).build();
            this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
        }
    }

    public void configureHistoricVariableInstanceQuery(HistoricVariableInstanceQueryImpl query) {
        this.configureHistoricVariableAndDetailQuery(query);
    }

    public void configureHistoricDetailQuery(HistoricDetailQueryImpl query) {
        this.configureHistoricVariableAndDetailQuery(query);
    }

    protected void configureHistoricVariableAndDetailQuery(AbstractQuery query) {
        boolean ensureSpecificVariablePermission = this.isEnsureSpecificVariablePermission();
        AuthManagerUtil.VariablePermissions variablePermissions = AuthManagerUtil.getVariablePermissions(ensureSpecificVariablePermission);
        Permission processDefinitionPermission = variablePermissions.getProcessDefinitionPermission();
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", processDefinitionPermission);
        } else {
            this.configureQuery(query);
            Permission historicTaskPermission = variablePermissions.getHistoricTaskPermission();
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", processDefinitionPermission).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).atomicCheck(Resources.HISTORIC_TASK, "TI.ID_", historicTaskPermission).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricJobLogQuery(HistoricJobLogQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROCESS_INSTANCE_ID_", HistoricProcessInstancePermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricIncidentQuery(HistoricIncidentQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricIdentityLinkQuery(HistoricIdentityLinkLogQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "TI.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).atomicCheck(Resources.HISTORIC_TASK, "RES.TASK_ID_", HistoricTaskPermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureHistoricDecisionInstanceQuery(HistoricDecisionInstanceQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "RES.DEC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricExternalTaskLogQuery(HistoricExternalTaskLogQueryImpl query) {
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (!isHistoricInstancePermissionsEnabled) {
            this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
        } else {
            this.configureQuery(query);
            CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).build();
            this.addPermissionCheck(authCheck, permissionCheck);
        }
    }

    public void configureUserOperationLogQuery(UserOperationLogQueryImpl query) {
        this.configureQuery(query);
        PermissionCheckBuilder permissionCheckBuilder = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY).atomicCheck(Resources.OPERATION_LOG_CATEGORY, "RES.CATEGORY_", Permissions.READ);
        AuthorizationCheck authCheck = query.getAuthCheck();
        boolean isHistoricInstancePermissionsEnabled = this.isHistoricInstancePermissionsEnabled();
        authCheck.setHistoricInstancePermissionsEnabled(isHistoricInstancePermissionsEnabled);
        if (isHistoricInstancePermissionsEnabled) {
            permissionCheckBuilder.atomicCheck(Resources.HISTORIC_PROCESS_INSTANCE, "RES.PROC_INST_ID_", HistoricProcessInstancePermissions.READ).atomicCheck(Resources.HISTORIC_TASK, "RES.TASK_ID_", HistoricTaskPermissions.READ);
        }
        CompositePermissionCheck permissionCheck = permissionCheckBuilder.build();
        this.addPermissionCheck(authCheck, permissionCheck);
    }

    public void configureHistoricBatchQuery(HistoricBatchQueryImpl query) {
        this.configureQuery(query, Resources.BATCH, "RES.ID_", Permissions.READ_HISTORY);
    }

    public void configureDeploymentStatisticsQuery(DeploymentStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.DEPLOYMENT, "RES.ID_");
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck processInstancePermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "EXECUTION.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).build();
            query.addProcessInstancePermissionCheck(processInstancePermissionCheck.getAllPermissionChecks());
            if (query.isFailedJobsToInclude()) {
                CompositePermissionCheck jobPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "JOB.PROCESS_INSTANCE_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "JOB.PROCESS_DEF_KEY_", Permissions.READ_INSTANCE).build();
                query.addJobPermissionCheck(jobPermissionCheck.getAllPermissionChecks());
            }
            if (query.isIncidentsToInclude()) {
                CompositePermissionCheck incidentPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "INC.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).build();
                query.addIncidentPermissionCheck(incidentPermissionCheck.getAllPermissionChecks());
            }
        }
    }

    public void configureProcessDefinitionStatisticsQuery(ProcessDefinitionStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
    }

    public void configureActivityStatisticsQuery(ActivityStatisticsQueryImpl query) {
        this.configureQuery(query);
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        if (query.getAuthCheck().isAuthorizationCheckEnabled()) {
            CompositePermissionCheck processInstancePermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "E.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ_INSTANCE).build();
            query.getAuthCheck().setPermissionChecks(processInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(processInstancePermissionCheck.getAllPermissionChecks());
            if (query.isFailedJobsToInclude()) {
                CompositePermissionCheck jobPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "JOB.PROCESS_INSTANCE_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "JOB.PROCESS_DEF_KEY_", Permissions.READ_INSTANCE).build();
                query.getAuthCheck().setPermissionChecks(jobPermissionCheck);
                query.addJobPermissionCheck(jobPermissionCheck.getAllPermissionChecks());
            }
            if (query.isIncidentsToInclude()) {
                CompositePermissionCheck incidentPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "I.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE).build();
                query.getAuthCheck().setPermissionChecks(incidentPermissionCheck);
                query.addIncidentPermissionCheck(incidentPermissionCheck.getAllPermissionChecks());
            }
        }
    }

    public void configureExternalTaskQuery(ExternalTaskQueryImpl query) {
        this.configureQuery(query);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE).build();
        this.addPermissionCheck(query.getAuthCheck(), permissionCheck);
    }

    public void configureExternalTaskFetch(ListQueryParameterObject parameter) {
        this.configureQuery(parameter);
        CompositePermissionCheck permissionCheck = this.newPermissionCheckBuilder().conjunctive().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE).done().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.UPDATE).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.UPDATE_INSTANCE).done().build();
        this.addPermissionCheck(parameter.getAuthCheck(), permissionCheck);
    }

    public void configureDecisionDefinitionQuery(DecisionDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "RES.KEY_");
    }

    public void configureDecisionRequirementsDefinitionQuery(DecisionRequirementsDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_REQUIREMENTS_DEFINITION, "RES.KEY_");
    }

    public void configureBatchQuery(BatchQueryImpl query) {
        this.configureQuery(query, Resources.BATCH, "RES.ID_", Permissions.READ);
    }

    public void configureBatchStatisticsQuery(BatchStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.BATCH, "RES.ID_", Permissions.READ);
    }

    public List<String> filterAuthenticatedGroupIds(List<String> authenticatedGroupIds) {
        if (authenticatedGroupIds == null || authenticatedGroupIds.isEmpty()) {
            return EMPTY_LIST;
        }
        HashSet<String> groupIntersection = new HashSet<String>(this.getAllGroups());
        groupIntersection.retainAll(authenticatedGroupIds);
        return new ArrayList<String>(groupIntersection);
    }

    protected Set<String> getAllGroups() {
        if (this.availableAuthorizedGroupIds == null) {
            this.availableAuthorizedGroupIds = new HashSet<String>();
            List groupsFromDatabase = this.getDbEntityManager().selectList("selectAuthorizedGroupIds");
            groupsFromDatabase.stream().filter(Objects::nonNull).forEach(this.availableAuthorizedGroupIds::add);
        }
        return this.availableAuthorizedGroupIds;
    }

    protected boolean isAuthCheckExecuted() {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = Context.getCommandContext();
        return this.isAuthorizationEnabled() && commandContext.isAuthorizationCheckEnabled() && currentAuthentication != null && currentAuthentication.getUserId() != null;
    }

    public boolean isEnsureSpecificVariablePermission() {
        return Context.getProcessEngineConfiguration().isEnforceSpecificVariablePermission();
    }

    protected boolean isHistoricInstancePermissionsEnabled() {
        return Context.getProcessEngineConfiguration().isEnableHistoricInstancePermissions();
    }

    public DbOperation addRemovalTimeToAuthorizationsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(AuthorizationEntity.class, "updateAuthorizationsByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToAuthorizationsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(AuthorizationEntity.class, "updateAuthorizationsByProcessInstanceId", parameters);
    }

    public DbOperation deleteAuthorizationsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(AuthorizationEntity.class, "deleteAuthorizationsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

