/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.Direction;
import org.operaton.bpm.engine.impl.QueryOrderingProperty;
import org.operaton.bpm.engine.impl.QueryPropertyImpl;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.operaton.bpm.engine.impl.persistence.entity.CommentEntity;
import org.operaton.bpm.engine.task.Comment;
import org.operaton.bpm.engine.task.Event;

public class CommentManager
extends AbstractHistoricManager {
    @Override
    public void delete(DbEntity dbEntity) {
        this.checkHistoryEnabled();
        super.delete(dbEntity);
    }

    @Override
    public void insert(DbEntity dbEntity) {
        this.checkHistoryEnabled();
        super.insert(dbEntity);
    }

    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectCommentsByTaskId", taskId);
    }

    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        ListQueryParameterObject query = new ListQueryParameterObject();
        query.setParameter(taskId);
        query.getOrderingProperties().add(new QueryOrderingProperty(new QueryPropertyImpl("TIME_"), Direction.DESCENDING));
        return this.getDbEntityManager().selectList("selectEventsByTaskId", query);
    }

    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        this.getDbEntityManager().delete(CommentEntity.class, "deleteCommentsByTaskId", taskId);
    }

    public void deleteCommentsByProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", processInstanceIds);
        this.deleteComments(parameters);
    }

    public void deleteCommentsByTaskProcessInstanceIds(List<String> processInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", processInstanceIds);
        this.deleteComments(parameters);
    }

    public void deleteCommentsByTaskCaseInstanceIds(List<String> caseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskCaseInstanceIds", caseInstanceIds);
        this.deleteComments(parameters);
    }

    protected void deleteComments(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(CommentEntity.class, "deleteCommentsByIds", parameters);
    }

    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbEntityManager().selectList("selectCommentsByProcessInstanceId", processInstanceId);
    }

    public CommentEntity findCommentByTaskIdAndCommentId(String taskId, String commentId) {
        this.checkHistoryEnabled();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("id", commentId);
        return (CommentEntity)this.getDbEntityManager().selectOne("selectCommentByTaskIdAndCommentId", parameters);
    }

    public DbOperation addRemovalTimeToCommentsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(CommentEntity.class, "updateCommentsByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToCommentsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(CommentEntity.class, "updateCommentsByProcessInstanceId", parameters);
    }

    public DbOperation deleteCommentsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(CommentEntity.class, "deleteCommentsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

