/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.CancelBoundaryEventActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.CancelEndEventActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.CompensationEventActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.operaton.bpm.engine.impl.core.model.CoreActivity;
import org.operaton.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.operaton.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.operaton.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceHistoryListener;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.PvmScope;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.operaton.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.tree.ExecutionWalker;
import org.operaton.bpm.engine.impl.tree.ReferenceWalker;

public class LegacyBehavior {
    private static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;

    public static void pruneConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureConcurrentScope(execution);
        LOG.debugConcurrentScopeIsPruned(execution);
        execution.setConcurrent(false);
    }

    public static void cancelConcurrentScope(PvmExecutionImpl execution, PvmActivity cancelledScopeActivity) {
        LegacyBehavior.ensureConcurrentScope(execution);
        LOG.debugCancelConcurrentScopeExecution(execution);
        execution.interrupt("Scope " + cancelledScopeActivity + " cancelled.");
        execution.setActivity(cancelledScopeActivity);
        execution.leaveActivityInstance();
        execution.interrupt("Scope " + cancelledScopeActivity + " cancelled.");
        execution.destroy();
    }

    public static void destroyConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureConcurrentScope(execution);
        LOG.destroyConcurrentScopeExecution(execution);
        execution.destroy();
    }

    public static boolean eventSubprocessComplete(ActivityExecution scopeExecution) {
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(scopeExecution);
        if (performLegacyBehavior) {
            LOG.completeNonScopeEventSubprocess();
            scopeExecution.end(false);
        }
        return performLegacyBehavior;
    }

    public static boolean eventSubprocessConcurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(endedExecution);
        if (performLegacyBehavior) {
            LOG.endConcurrentExecutionInEventSubprocess();
            ScopeImpl flowScope = endedExecution.getActivity().getFlowScope();
            if (flowScope != null && (flowScope = flowScope.getFlowScope()) != null) {
                if (flowScope == endedExecution.getActivity().getProcessDefinition()) {
                    endedExecution.remove();
                    scopeExecution.tryPruneLastConcurrentChild();
                    scopeExecution.forceUpdate();
                } else {
                    PvmActivity flowScopeActivity = (PvmActivity)((Object)flowScope);
                    ActivityBehavior activityBehavior = flowScopeActivity.getActivityBehavior();
                    if (activityBehavior instanceof CompositeActivityBehavior) {
                        ((CompositeActivityBehavior)activityBehavior).concurrentChildExecutionEnded(scopeExecution, endedExecution);
                    }
                }
            }
        }
        return performLegacyBehavior;
    }

    public static boolean destroySecondNonScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureScope(execution);
        boolean performLegacyBehavior = LegacyBehavior.isLegacyBehaviorRequired(execution);
        if (performLegacyBehavior) {
            // empty if block
        }
        return performLegacyBehavior;
    }

    protected static boolean isLegacyBehaviorRequired(ActivityExecution scopeExecution) {
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = scopeExecution.createActivityExecutionMapping();
        PvmScope activity = scopeExecution.getActivity();
        if (!activity.isScope()) {
            activity = activity.getFlowScope();
        }
        return activityExecutionMapping.get(activity) == activityExecutionMapping.get(activity.getFlowScope());
    }

    public static PvmExecutionImpl getScopeExecution(ScopeImpl scope, Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping) {
        ScopeImpl flowScope = scope.getFlowScope();
        return activityExecutionMapping.get(flowScope);
    }

    protected static void ensureConcurrentScope(PvmExecutionImpl execution) {
        LegacyBehavior.ensureScope(execution);
        LegacyBehavior.ensureConcurrent(execution);
    }

    protected static void ensureConcurrent(PvmExecutionImpl execution) {
        if (!execution.isConcurrent()) {
            throw new ProcessEngineException("Execution must be concurrent.");
        }
    }

    protected static void ensureScope(PvmExecutionImpl execution) {
        if (!execution.isScope()) {
            throw new ProcessEngineException("Execution must be scope.");
        }
    }

    public static Map<ScopeImpl, PvmExecutionImpl> createActivityExecutionMapping(List<PvmExecutionImpl> scopeExecutions, List<ScopeImpl> scopes) {
        PvmExecutionImpl deepestExecution = scopeExecutions.get(0);
        if (LegacyBehavior.isLegacyAsyncAtMultiInstance(deepestExecution)) {
            scopes.remove(0);
        }
        int numOfMissingExecutions = scopes.size() - scopeExecutions.size();
        Collections.reverse(scopeExecutions);
        Collections.reverse(scopes);
        HashMap<ScopeImpl, PvmExecutionImpl> mapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
        mapping.put(scopes.get(0), scopeExecutions.get(0));
        int executionCounter = 0;
        for (int i = 1; i < scopes.size(); ++i) {
            ActivityImpl scope = (ActivityImpl)scopes.get(i);
            PvmExecutionImpl scopeExecutionCandidate = null;
            if (executionCounter + 1 < scopeExecutions.size()) {
                scopeExecutionCandidate = scopeExecutions.get(executionCounter + 1);
            }
            if (numOfMissingExecutions > 0 && LegacyBehavior.wasNoScope(scope, scopeExecutionCandidate)) {
                --numOfMissingExecutions;
            } else {
                ++executionCounter;
            }
            if (executionCounter >= scopeExecutions.size()) {
                throw new ProcessEngineException("Cannot construct activity-execution mapping: there are more scope executions missing than explained by the flow scope hierarchy.");
            }
            PvmExecutionImpl execution = scopeExecutions.get(executionCounter);
            mapping.put(scope, execution);
        }
        return mapping;
    }

    protected static boolean wasNoScope(ActivityImpl activity, PvmExecutionImpl scopeExecutionCandidate) {
        return LegacyBehavior.wasNoScope72(activity) || LegacyBehavior.wasNoScope73(activity, scopeExecutionCandidate);
    }

    protected static boolean wasNoScope72(ActivityImpl activity) {
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        ActivityBehavior parentActivityBehavior = (ActivityBehavior)(activity.getFlowScope() != null ? activity.getFlowScope().getActivityBehavior() : null);
        return activityBehavior instanceof EventSubProcessActivityBehavior || activityBehavior instanceof SubProcessActivityBehavior && parentActivityBehavior instanceof SequentialMultiInstanceActivityBehavior || activityBehavior instanceof ReceiveTaskActivityBehavior && parentActivityBehavior instanceof MultiInstanceActivityBehavior;
    }

    protected static boolean wasNoScope73(ActivityImpl activity, PvmExecutionImpl scopeExecutionCandidate) {
        ActivityBehavior activityBehavior = activity.getActivityBehavior();
        return activityBehavior instanceof CompensationEventActivityBehavior || activityBehavior instanceof CancelEndEventActivityBehavior || LegacyBehavior.isMultiInstanceInCompensation(activity, scopeExecutionCandidate);
    }

    protected static boolean isMultiInstanceInCompensation(ActivityImpl activity, PvmExecutionImpl scopeExecutionCandidate) {
        return activity.getActivityBehavior() instanceof MultiInstanceActivityBehavior && (scopeExecutionCandidate != null && LegacyBehavior.findCompensationThrowingAncestorExecution(scopeExecutionCandidate) != null || scopeExecutionCandidate == null);
    }

    protected static boolean isLegacyAsyncAtMultiInstance(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            boolean isAsync = execution.getActivityInstanceId() == null;
            boolean isAtMultiInstance = activity.getParentFlowScopeActivity() != null && activity.getParentFlowScopeActivity().getActivityBehavior() instanceof MultiInstanceActivityBehavior;
            return isAsync && isAtMultiInstance;
        }
        return false;
    }

    public static PvmExecutionImpl determinePropagatingExecutionOnEnd(PvmExecutionImpl propagatingExecution, Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping) {
        if (!propagatingExecution.isScope()) {
            return propagatingExecution;
        }
        if (activityExecutionMapping.values().contains(propagatingExecution)) {
            return propagatingExecution;
        }
        propagatingExecution.remove();
        PvmExecutionImpl parent = propagatingExecution.getParent();
        parent.setActivity(propagatingExecution.getActivity());
        return propagatingExecution.getParent();
    }

    public static boolean isConcurrentScope(PvmExecutionImpl propagatingExecution) {
        return propagatingExecution.isConcurrent() && propagatingExecution.isScope();
    }

    public static void removeLegacySubscriptionOnParent(ExecutionEntity execution, EventSubscriptionEntity eventSubscription) {
        ActivityImpl activity = execution.getActivity();
        if (activity == null) {
            return;
        }
        ActivityBehavior behavior = activity.getActivityBehavior();
        ActivityBehavior parentBehavior = (ActivityBehavior)(activity.getFlowScope() != null ? activity.getFlowScope().getActivityBehavior() : null);
        if (behavior instanceof ReceiveTaskActivityBehavior && parentBehavior instanceof MultiInstanceActivityBehavior) {
            List<EventSubscriptionEntity> parentSubscriptions = execution.getParent().getEventSubscriptions();
            for (EventSubscriptionEntity subscription : parentSubscriptions) {
                if (!LegacyBehavior.areEqualEventSubscriptions(subscription, eventSubscription)) continue;
                subscription.delete();
            }
        }
    }

    protected static boolean areEqualEventSubscriptions(EventSubscriptionEntity subscription1, EventSubscriptionEntity subscription2) {
        return LegacyBehavior.valuesEqual(subscription1.getEventType(), subscription2.getEventType()) && LegacyBehavior.valuesEqual(subscription1.getEventName(), subscription2.getEventName()) && LegacyBehavior.valuesEqual(subscription1.getActivityId(), subscription2.getActivityId());
    }

    protected static <T> boolean valuesEqual(T value1, T value2) {
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    public static void removeLegacyNonScopesFromMapping(Map<ScopeImpl, PvmExecutionImpl> mapping) {
        HashMap<PvmExecutionImpl, ArrayList<ScopeImpl>> scopesForExecutions = new HashMap<PvmExecutionImpl, ArrayList<ScopeImpl>>();
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> entry : mapping.entrySet()) {
            ArrayList<ScopeImpl> scopesForExecution = (ArrayList<ScopeImpl>)scopesForExecutions.get(entry.getValue());
            if (scopesForExecution == null) {
                scopesForExecution = new ArrayList<ScopeImpl>();
                scopesForExecutions.put(entry.getValue(), scopesForExecution);
            }
            scopesForExecution.add(entry.getKey());
        }
        for (Map.Entry<ScopeImpl, PvmExecutionImpl> entry : scopesForExecutions.entrySet()) {
            List scopes = (List)((Object)entry.getValue());
            if (scopes.size() <= 1) continue;
            ScopeImpl topMostScope = LegacyBehavior.getTopMostScope(scopes);
            for (ScopeImpl scope : scopes) {
                if (scope == scope.getProcessDefinition() || scope == topMostScope) continue;
                mapping.remove(scope);
            }
        }
    }

    protected static ScopeImpl getTopMostScope(List<ScopeImpl> scopes) {
        ScopeImpl topMostScope = null;
        for (ScopeImpl candidateScope : scopes) {
            if (topMostScope != null && !candidateScope.isAncestorFlowScopeOf(topMostScope)) continue;
            topMostScope = candidateScope;
        }
        return topMostScope;
    }

    public static void repairParentRelationships(Collection<ActivityInstanceImpl> values, String processInstanceId) {
        for (ActivityInstanceImpl activityInstance : values) {
            if (!LegacyBehavior.valuesEqual(activityInstance.getId(), activityInstance.getParentActivityInstanceId())) continue;
            activityInstance.setParentActivityInstanceId(processInstanceId);
        }
    }

    public static void migrateMultiInstanceJobDefinitions(ProcessDefinitionEntity processDefinition, List<JobDefinitionEntity> jobDefinitions) {
        for (JobDefinitionEntity jobDefinition : jobDefinitions) {
            ActivityImpl activity;
            String activityId = jobDefinition.getActivityId();
            if (activityId == null || LegacyBehavior.isAsync(activity = processDefinition.findActivity(jobDefinition.getActivityId())) || !LegacyBehavior.isActivityWrappedInMultiInstanceBody(activity) || !LegacyBehavior.isAsyncJobDefinition(jobDefinition)) continue;
            jobDefinition.setActivityId(activity.getFlowScope().getId());
        }
    }

    protected static boolean isAsync(ActivityImpl activity) {
        return activity.isAsyncBefore() || activity.isAsyncAfter();
    }

    protected static boolean isAsyncJobDefinition(JobDefinitionEntity jobDefinition) {
        return "async-continuation".equals(jobDefinition.getJobType());
    }

    protected static boolean isActivityWrappedInMultiInstanceBody(ActivityImpl activity) {
        ScopeImpl flowScope = activity.getFlowScope();
        if (flowScope != activity.getProcessDefinition()) {
            ActivityImpl flowScopeActivity = (ActivityImpl)flowScope;
            return flowScopeActivity.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
        }
        return false;
    }

    public static void repairMultiInstanceAsyncJob(ExecutionEntity execution) {
        ActivityImpl activity = execution.getActivity();
        if (!LegacyBehavior.isAsync(activity) && LegacyBehavior.isActivityWrappedInMultiInstanceBody(activity)) {
            execution.setActivity((ActivityImpl)activity.getFlowScope());
        }
    }

    public static boolean signalCancelBoundaryEvent(String signalName) {
        return "compensationDone".equals(signalName);
    }

    public static void parseCancelBoundaryEvent(ActivityImpl activity) {
        activity.setProperty("throwsCompensation", true);
    }

    public static boolean hasInvalidIntermediaryActivityId(PvmExecutionImpl execution) {
        return !execution.getNonEventScopeExecutions().isEmpty() && !CompensationBehavior.isCompensationThrowing(execution);
    }

    public static boolean isCompensationThrowing(PvmExecutionImpl execution, Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping) {
        if (CompensationBehavior.isCompensationThrowing(execution)) {
            ActivityImpl compensationThrowingActivity = execution.getActivity();
            if (compensationThrowingActivity.isScope()) {
                return activityExecutionMapping.get(compensationThrowingActivity) == activityExecutionMapping.get(compensationThrowingActivity.getFlowScope());
            }
            return ((CoreActivity)compensationThrowingActivity).getActivityBehavior() instanceof CancelBoundaryEventActivityBehavior;
        }
        return false;
    }

    public static boolean isCompensationThrowing(PvmExecutionImpl execution) {
        return LegacyBehavior.isCompensationThrowing(execution, execution.createActivityExecutionMapping());
    }

    protected static PvmExecutionImpl findCompensationThrowingAncestorExecution(PvmExecutionImpl execution) {
        ExecutionWalker walker = new ExecutionWalker(execution);
        walker.walkUntil(new ReferenceWalker.WalkCondition<PvmExecutionImpl>(){

            @Override
            public boolean isFulfilled(PvmExecutionImpl element) {
                return element == null || CompensationBehavior.isCompensationThrowing(element);
            }
        });
        return (PvmExecutionImpl)walker.getCurrentElement();
    }

    public static void createMissingHistoricVariables(PvmExecutionImpl execution) {
        Collection<VariableInstanceEntity> variables = ((ExecutionEntity)execution).getVariablesInternal();
        if (variables != null && variables.size() > 0) {
            for (VariableInstanceEntity variable : variables) {
                if (!variable.wasCreatedBefore713()) continue;
                VariableInstanceHistoryListener.INSTANCE.onCreate(variable, (AbstractVariableScope)variable.getExecution());
            }
        }
    }
}

