/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.ScopeInstantiationContext;
import org.operaton.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationActivityInitStack
implements PvmAtomicOperation {
    protected PvmAtomicOperation operationOnScopeInitialization;

    public PvmAtomicOperationActivityInitStack(PvmAtomicOperation operationOnScopeInitialization) {
        this.operationOnScopeInitialization = operationOnScopeInitialization;
    }

    @Override
    public String getCanonicalName() {
        return "activity-stack-init";
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        ScopeInstantiationContext executionStartContext = execution.getScopeInstantiationContext();
        InstantiationStack instantiationStack = executionStartContext.getInstantiationStack();
        List<PvmActivity> activityStack = instantiationStack.getActivities();
        PvmActivity currentActivity = activityStack.remove(0);
        PvmExecutionImpl propagatingExecution = execution;
        if (currentActivity.isScope()) {
            propagatingExecution = execution.createExecution();
            execution.setActive(false);
            propagatingExecution.setActivity(currentActivity);
            propagatingExecution.initialize();
        } else {
            propagatingExecution.setActivity(currentActivity);
        }
        propagatingExecution.performOperation(this.operationOnScopeInitialization);
    }

    @Override
    public boolean isAsync(PvmExecutionImpl instance) {
        return false;
    }

    public PvmExecutionImpl getStartContextExecution(PvmExecutionImpl execution) {
        return execution;
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }
}

