/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime.operation;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.pvm.PvmLogger;
import org.operaton.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;

public abstract class PvmAtomicOperationActivityInstanceEnd
extends AbstractPvmEventAtomicOperation {
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.incrementSequenceCounter();
        PvmExecutionImpl parent = execution.getParent();
        ActivityImpl activity = execution.getActivity();
        if (parent != null && execution.isScope() && activity != null && activity.isScope() && (activity.getActivityBehavior() instanceof CompositeActivityBehavior || CompensationBehavior.isCompensationThrowing(execution) && !LegacyBehavior.isCompensationThrowing(execution))) {
            LOG.debugLeavesActivityInstance(execution, execution.getActivityInstanceId());
            execution.setActivityInstanceId(parent.getActivityInstanceId());
            parent.leaveActivityInstance();
        }
        execution.setTransition(null);
        return execution;
    }

    @Override
    protected void eventNotificationsFailed(PvmExecutionImpl execution, Exception e) {
        execution.activityInstanceEndListenerFailure();
        super.eventNotificationsFailed(execution, e);
    }

    @Override
    protected boolean isSkipNotifyListeners(PvmExecutionImpl execution) {
        return execution.getActivityInstanceId() == null;
    }
}

