/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.telemetry.reporter;

import java.util.Timer;
import java.util.TimerTask;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.IsTelemetryEnabledCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.metrics.MetricsRegistry;
import org.operaton.bpm.engine.impl.telemetry.TelemetryLogger;
import org.operaton.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.operaton.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.operaton.bpm.engine.impl.telemetry.reporter.TelemetrySendingTask;
import org.operaton.connect.spi.Connector;
import org.operaton.connect.spi.ConnectorRequest;

public class TelemetryReporter {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected long reportingIntervalInSeconds;
    public static long DEFAULT_INIT_REPORT_DELAY_SECONDS = 300L;
    public static long EXTENDED_INIT_REPORT_DELAY_SECONDS = 10800L;
    protected TelemetrySendingTask telemetrySendingTask;
    protected Timer timer;
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected int telemetryRequestRetries;
    protected TelemetryDataImpl data;
    protected Connector<? extends ConnectorRequest<?>> httpConnector;
    protected TelemetryRegistry telemetryRegistry;
    protected MetricsRegistry metricsRegistry;
    protected int telemetryRequestTimeout;

    public TelemetryReporter(CommandExecutor commandExecutor, String telemetryEndpoint, int telemetryRequestRetries, long telemetryReportingPeriod, TelemetryDataImpl data, Connector<? extends ConnectorRequest<?>> httpConnector, TelemetryRegistry telemetryRegistry, MetricsRegistry metricsRegistry, int telemetryRequestTimeout) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.telemetryRequestRetries = telemetryRequestRetries;
        this.reportingIntervalInSeconds = telemetryReportingPeriod;
        this.data = data;
        this.httpConnector = httpConnector;
        this.telemetryRegistry = telemetryRegistry;
        this.metricsRegistry = metricsRegistry;
        this.telemetryRequestTimeout = telemetryRequestTimeout;
        this.initTelemetrySendingTask();
    }

    protected void initTelemetrySendingTask() {
        this.telemetrySendingTask = new TelemetrySendingTask(this.commandExecutor, this.telemetryEndpoint, this.telemetryRequestRetries, this.data, this.httpConnector, this.telemetryRegistry, this.metricsRegistry, this.telemetryRequestTimeout);
    }

    public synchronized void start() {
        if (!this.isScheduled()) {
            this.initTelemetrySendingTask();
            this.timer = new Timer("Operaton BPM Runtime Telemetry Reporter", true);
            long reportingIntervalInMillis = this.reportingIntervalInSeconds * 1000L;
            long initialReportingDelay = this.getInitialReportingDelaySeconds() * 1000L;
            try {
                this.timer.scheduleAtFixedRate((TimerTask)this.telemetrySendingTask, initialReportingDelay, reportingIntervalInMillis);
            }
            catch (Exception e) {
                this.timer = null;
                throw LOG.schedulingTaskFails(e);
            }
        }
    }

    public synchronized void reschedule() {
        this.stop(false);
        this.start();
    }

    public synchronized void stop() {
        this.stop(true);
    }

    public synchronized void stop(boolean report) {
        if (this.isScheduled()) {
            this.timer.cancel();
            this.timer = null;
            if (report) {
                this.reportNow();
            }
        }
    }

    public void reportNow() {
        if (this.telemetrySendingTask != null) {
            this.telemetrySendingTask.run();
        }
    }

    public boolean isScheduled() {
        return this.timer != null;
    }

    public long getReportingIntervalInSeconds() {
        return this.reportingIntervalInSeconds;
    }

    public TelemetrySendingTask getTelemetrySendingTask() {
        return this.telemetrySendingTask;
    }

    public void setTelemetrySendingTask(TelemetrySendingTask telemetrySendingTask) {
        this.telemetrySendingTask = telemetrySendingTask;
    }

    public String getTelemetryEndpoint() {
        return this.telemetryEndpoint;
    }

    public Connector<? extends ConnectorRequest<?>> getHttpConnector() {
        return this.httpConnector;
    }

    public long getInitialReportingDelaySeconds() {
        Boolean enabled = this.commandExecutor.execute(new IsTelemetryEnabledCmd());
        return enabled == null ? EXTENDED_INIT_REPORT_DELAY_SECONDS : DEFAULT_INIT_REPORT_DELAY_SECONDS;
    }
}

