/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;

public class IoUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;

    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw LOG.exceptionWhileReadingStream(inputStreamName, e);
        }
        return outputStream.toByteArray();
    }

    public static String readClasspathResourceAsString(String resourceName) {
        byte[] result;
        InputStream resourceAsStream = IoUtil.class.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new ProcessEngineException("resource " + resourceName + " not found");
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        BufferedInputStream inputStream = null;
        try {
            int next;
            inputStream = new BufferedInputStream(resourceAsStream);
            while ((next = inputStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, next);
            }
            result = outStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw LOG.exceptionWhileReadingFile(resourceName, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                IoUtil.closeSilently(outStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
        IoUtil.closeSilently(outStream);
        return new String(result, Charset.forName("UTF-8"));
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw LOG.exceptionWhileGettingFile(filePath, e);
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(IoUtil.getFile(filePath)));
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw LOG.exceptionWhileWritingToFile(filePath, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(outputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(outputStream);
    }

    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }

    public static void flushSilently(Flushable flushable) {
        try {
            if (flushable != null) {
                flushable.flush();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }
}

