/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.authorization.BatchPermissions;
import org.operaton.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.operaton.bpm.engine.authorization.HistoricTaskPermissions;
import org.operaton.bpm.engine.authorization.OptimizePermissions;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.operaton.bpm.engine.authorization.ProcessInstancePermissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.authorization.SystemPermissions;
import org.operaton.bpm.engine.authorization.TaskPermissions;
import org.operaton.bpm.engine.authorization.UserOperationLogCategoryPermissions;

public class ResourceTypeUtil {
    protected static final Map<Integer, Class<? extends Enum<? extends Permission>>> PERMISSION_ENUMS = new HashMap<Integer, Class<? extends Enum<? extends Permission>>>(){
        {
            this.put(Resources.BATCH.resourceType(), BatchPermissions.class);
            this.put(Resources.PROCESS_DEFINITION.resourceType(), ProcessDefinitionPermissions.class);
            this.put(Resources.PROCESS_INSTANCE.resourceType(), ProcessInstancePermissions.class);
            this.put(Resources.TASK.resourceType(), TaskPermissions.class);
            this.put(Resources.HISTORIC_TASK.resourceType(), HistoricTaskPermissions.class);
            this.put(Resources.HISTORIC_PROCESS_INSTANCE.resourceType(), HistoricProcessInstancePermissions.class);
            this.put(Resources.OPERATION_LOG_CATEGORY.resourceType(), UserOperationLogCategoryPermissions.class);
            this.put(Resources.OPTIMIZE.resourceType(), OptimizePermissions.class);
            this.put(Resources.SYSTEM.resourceType(), SystemPermissions.class);
        }
    };

    public static boolean resourceIsContainedInArray(Integer resourceTypeId, Resource[] resources) {
        for (Resource resource : resources) {
            if (resourceTypeId.intValue() != resource.resourceType()) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, Class<? extends Enum<? extends Permission>>> getPermissionEnums() {
        return PERMISSION_ENUMS;
    }

    public static Permission[] getPermissionsByResourceType(int givenResourceType) {
        Class<? extends Enum<? extends Permission>> clazz = PERMISSION_ENUMS.get(givenResourceType);
        if (clazz == null) {
            return Permissions.values();
        }
        return (Permission[])clazz.getEnumConstants();
    }

    public static Permission getPermissionByNameAndResourceType(String permissionName, int resourceType) {
        for (Permission permission : ResourceTypeUtil.getPermissionsByResourceType(resourceType)) {
            if (!permission.getName().equals(permissionName)) continue;
            return permission;
        }
        throw new BadUserRequestException(String.format("The permission '%s' is not valid for '%s' resource type.", permissionName, ResourceTypeUtil.getResourceByType(resourceType)));
    }

    public static Resource getResourceByType(int resourceType) {
        for (Resources resource : Resources.values()) {
            if (resource.resourceType() != resourceType) continue;
            return resource;
        }
        return null;
    }

    static {
        for (Permissions permission : Permissions.values()) {
            if (permission.equals(Permissions.ALL) || permission.equals(Permissions.NONE)) continue;
            for (Resource resource : permission.getTypes()) {
                int resourceType = resource.resourceType();
                if (PERMISSION_ENUMS.containsKey(resourceType)) continue;
                PERMISSION_ENUMS.put(resourceType, Permissions.class);
            }
        }
    }
}

