/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util.xml;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.operaton.bpm.engine.BpmnParseException;
import org.operaton.bpm.engine.Problem;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;
import org.operaton.bpm.engine.impl.util.io.InputStreamSource;
import org.operaton.bpm.engine.impl.util.io.ResourceStreamSource;
import org.operaton.bpm.engine.impl.util.io.StreamSource;
import org.operaton.bpm.engine.impl.util.io.StringStreamSource;
import org.operaton.bpm.engine.impl.util.io.UrlStreamSource;
import org.operaton.bpm.engine.impl.util.xml.Element;
import org.operaton.bpm.engine.impl.util.xml.ParseHandler;
import org.operaton.bpm.engine.impl.util.xml.Parser;
import org.operaton.bpm.engine.impl.xml.ProblemImpl;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class Parse
extends DefaultHandler {
    protected static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY = "javax.xml.accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_ALL = "all";
    protected Parser parser;
    protected String name;
    protected StreamSource streamSource;
    protected Element rootElement = null;
    protected List<Problem> errors = new ArrayList<Problem>();
    protected List<Problem> warnings = new ArrayList<Problem>();
    protected String schemaResource;

    public Parse(Parser parser) {
        this.parser = parser;
    }

    public Parse name(String name) {
        this.name = name;
        return this;
    }

    public Parse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource(new InputStreamSource(inputStream));
        return this;
    }

    public Parse sourceResource(String resource) {
        return this.sourceResource(resource, null);
    }

    public Parse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource(new UrlStreamSource(url));
        return this;
    }

    public Parse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw LOG.malformedUrlException(url, e);
        }
    }

    public Parse sourceResource(String resource, ClassLoader classLoader) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource, classLoader));
        return this;
    }

    public Parse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource(new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw LOG.multipleSourcesException(this.streamSource, streamSource);
        }
        this.streamSource = streamSource;
    }

    public void setSchemaResource(String schemaResource) {
        boolean schemaResourceSet = schemaResource != null;
        this.parser.enableSchemaValidation(schemaResourceSet);
        this.schemaResource = schemaResource;
    }

    public Parse execute() {
        try {
            InputStream inputStream = this.streamSource.getInputStream();
            SAXParser saxParser = this.parser.getSaxParser();
            try {
                saxParser.setProperty(JAXP_ACCESS_EXTERNAL_SCHEMA, this.resolveAccessExternalSchemaProperty());
            }
            catch (Exception e) {
                LOG.logAccessExternalSchemaNotSupported(e);
            }
            if (this.schemaResource != null) {
                saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                saxParser.setProperty(JAXP_SCHEMA_SOURCE, this.schemaResource);
            }
            saxParser.parse(inputStream, (DefaultHandler)new ParseHandler(this));
        }
        catch (Exception e) {
            throw LOG.parsingFailureException(this.name, e);
        }
        return this;
    }

    protected String resolveAccessExternalSchemaProperty() {
        String systemProperty = System.getProperty(JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY);
        if (systemProperty != null) {
            return systemProperty;
        }
        return JAXP_ACCESS_EXTERNAL_SCHEMA_ALL;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public List<Problem> getProblems() {
        return this.errors;
    }

    public void addError(SAXParseException e) {
        this.errors.add(new ProblemImpl(e));
    }

    public void addError(String errorMessage, Element element) {
        this.errors.add(new ProblemImpl(errorMessage, element));
    }

    public void addError(String errorMessage, Element element, String ... elementIds) {
        this.errors.add(new ProblemImpl(errorMessage, element, elementIds));
    }

    public void addError(BpmnParseException e) {
        this.errors.add(new ProblemImpl(e));
    }

    public void addError(BpmnParseException e, String elementId) {
        this.errors.add(new ProblemImpl(e, elementId));
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public void addWarning(SAXParseException e) {
        this.warnings.add(new ProblemImpl(e));
    }

    public void addWarning(String errorMessage, Element element) {
        this.warnings.add(new ProblemImpl(errorMessage, element));
    }

    public void addWarning(String errorMessage, Element element, String ... elementIds) {
        this.warnings.add(new ProblemImpl(errorMessage, element, elementIds));
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public void logWarnings() {
        StringBuilder builder = new StringBuilder();
        for (Problem warning : this.warnings) {
            builder.append("\n* ");
            builder.append(warning.getMessage());
            builder.append(" | resource " + this.name);
            builder.append(warning.toString());
        }
        LOG.logParseWarnings(builder.toString());
    }

    public void throwExceptionForErrors() {
        StringBuilder strb = new StringBuilder();
        for (Problem error : this.errors) {
            strb.append("\n* ");
            strb.append(error.getMessage());
            strb.append(" | resource " + this.name);
            strb.append(error.toString());
        }
        throw LOG.exceptionDuringParsing(strb.toString(), this.name, this.errors, this.warnings);
    }
}

