/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import org.operaton.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.StringValue;

public class StringValueSerializer
extends PrimitiveValueSerializer<StringValue> {
    public static final String EMPTY_STRING = "!emptyString!";

    public StringValueSerializer() {
        super(ValueType.STRING);
    }

    @Override
    public StringValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.stringValue((String)((String)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public StringValue readValue(ValueFields valueFields, boolean asTransientValue) {
        String textValue = valueFields.getTextValue();
        if (textValue == null && EMPTY_STRING.equals(valueFields.getTextValue2())) {
            textValue = "";
        }
        return Variables.stringValue((String)textValue, (boolean)asTransientValue);
    }

    @Override
    public void writeValue(StringValue variableValue, ValueFields valueFields) {
        String value = (String)variableValue.getValue();
        valueFields.setTextValue(value);
        if ("".equals(value)) {
            valueFields.setTextValue2(EMPTY_STRING);
        }
    }
}

